package com.atlassian.user.search.query;

import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.search.SearchResult;

/**
 * Parses and executes queries for users and groups against one or more Atlassian-User repositories.
 * Implementations generally support single-term and arbitrarily nested boolean queries for user and
 * group properties.
 * <p/>
 * Membership queries are not supported and have been officially deprecated as of Atlassian-User 2.1.
 *
 * @see Query
 * @see UserQuery
 * @see GroupQuery
 */
public interface EntityQueryParser
{
    /**
     * Returns the users matching the provided query.
     *
     * @throws EntityQueryException if the query is a boolean query constructed from different term types
     * @throws IllegalArgumentException if the query is a membership query
     * @throws EntityException is there is a problem performing the query (e.g. database connection failure)
     */
    SearchResult<User> findUsers(Query<User> query) throws EntityException;

    /**
     * Returns the groups matching the provided query.
     *
     * @throws EntityQueryException if the query is a boolean query constructed from different term types
     * @throws IllegalArgumentException if the query is a membership query
     * @throws EntityException is there is a problem performing the query (e.g. database connection failure)
     */
    SearchResult<Group> findGroups(Query<Group> query) throws EntityException;

    /**
     * If the repository matches the query context, returns the users matching the query, otherwise returns {@code null}.
     *
     * @throws EntityQueryException if the query is a boolean query constructed from different term types
     * @throws IllegalArgumentException if the query is a membership query
     * @throws EntityException is there is a problem performing the query (e.g. database connection failure)
     */
    SearchResult<User> findUsers(Query<User> query, QueryContext context) throws EntityException;

    /**
     * If the repository matches the query context, returns the groups matching the query, otherwise returns {@code null}.
     *
     * @throws EntityQueryException if the query is a boolean query constructed from different term types
     * @throws IllegalArgumentException if the query is a membership query
     * @throws EntityException is there is a problem performing the query (e.g. database connection failure)
     */
    SearchResult<Group> findGroups(Query<Group> query, QueryContext context) throws EntityException;
}
