package com.atlassian.user.search.query;

import com.atlassian.user.Entity;

public class AbstractSingleTermQuery<T extends Entity> implements TermQuery<T>
{
    protected String matchingRule;
    protected boolean matchingSubstring;
    protected String term;

    public AbstractSingleTermQuery(String term)
    {
        this.term = term;
    }

    public AbstractSingleTermQuery(String term, String matchingRule)
    {
        this.term = term;

        if (matchingRule != TermQuery.SUBSTRING_CONTAINS &&
                matchingRule != TermQuery.SUBSTRING_ENDS_WITH &&
                matchingRule != TermQuery.SUBSTRING_STARTS_WITH)
            throw new IllegalArgumentException("Invalid substring matching rule - please use " +
                    Query.class.getName() + "SUBSTRING_CONTAINS, SUBSTRING_ENDS_WITH, or " +
                    "SUBSTRING_STARTS_WITH");

        this.matchingRule = matchingRule;
        this.matchingSubstring = true;
    }

    /**
     * @return a String holding the system indepdent value of the term to match for equality.
     *         <p/>
     *         For example, in a ColourQuery this term might be 'red' but, when rendered, would be
     *         represented as "select colour from colour_table where colour == 'red'"
     */
    public String getTerm()
    {
        return term;
    }

    public String getMatchingRule()
    {
        return matchingRule;
    }

    public boolean isMatchingSubstring()
    {
        return matchingSubstring;
    }
}
