package com.atlassian.user.search.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class Pagers
{
    /**
     * Creates a new instance of {@link DefaultPager} with the provided elements.
     */
    public static <T> DefaultPager<T> newDefaultPager(Iterable<? extends T> elements)
    {
        if (elements instanceof Collection)
        {
            return new DefaultPager<T>(new ArrayList<T>((Collection<? extends T>) elements));
        }
        List<T> list = new ArrayList<T>();
        for (T element : elements)
        {
            list.add(element);
        }
        return new DefaultPager<T>(list);
    }

    public static <T> DefaultPager<T> newDefaultPager(T... elements)
    {
        return newDefaultPager(Arrays.asList(elements));
    }
}
