package com.atlassian.user.search.page;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Arrays;

public class PagerFactory
{
    /**
     * @return a merged pager composed of the two passed in
     */
    public static <T> Pager<T> getPager(Pager<T> pagerOne, Pager<T> pagerTwo)
    {
        return getPager(Arrays.asList(pagerOne, pagerTwo));
    }

    public static <T> Pager<T> getPager(List<Pager<T>> pagers)
    {
        final List<Pager<T>> pagersCopy = new ArrayList<Pager<T>>(pagers); 
        for (Iterator it = pagersCopy.iterator(); it.hasNext();)
        {
            Pager pager = (Pager) it.next();
            if (pager == null || pager.isEmpty())
                it.remove();
        }

        if (pagersCopy.size() == 0)
            return DefaultPager.emptyPager();

        if (pagersCopy.size() == 1)
            return pagersCopy.get(0);

        return new MergedListPager<T>(pagersCopy);
    }
}
