package com.atlassian.user.impl.osuser.config.xml;

import com.atlassian.user.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import java.util.Properties;

/**
 * Used to parse osuser.xml files.
 *
 * An implementation of {@link DefaultHandler} taken from the original OSUUser implementation.
 */
public class DefaultOSUConfigurationHandler extends DefaultHandler
{
    private static final Logger log = Logger.getLogger(DefaultOSUConfigurationHandler.class);
    private DefaultOSUConfigurationLoader configLoader;
    private String currentClass;
    private Properties currentProperties;

    public DefaultOSUConfigurationHandler(DefaultOSUConfigurationLoader configLoader)
    {
        this.configLoader = configLoader;
    }

    /**
     * SAX Handler implementation for handling tags in config file and building
     * config objects.
     */
    private String _currentPropertyName;
    private StringBuffer _currentPropertyValue;

    public void characters(char[] chars, int offset, int len) throws SAXException
    {
        if (_currentPropertyValue != null)
        {
            _currentPropertyValue.append(chars, offset, len);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException
    {
        if (qName.equals("provider"))
        {
            try
            {
                configLoader.addProvider(currentClass, currentProperties);
            }
            catch (ConfigurationException e)
            {
                log.error(e);
            }
            currentProperties = null;
            currentClass = null;
        }
        else if (qName.equals("authenticator"))
        {
//            configLoader.addAuthenticator(currentClass, currentProperties);
            currentProperties = null;
            currentClass = null;
        }
        else if (qName.equals("property"))
        {
            currentProperties.put(_currentPropertyName, _currentPropertyValue.toString());
            _currentPropertyName = null;
            _currentPropertyValue = null;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException
    {
        if (qName.equals("provider") || qName.equals("authenticator"))
        {
            currentClass = attributes.getValue("class");
            currentProperties = new Properties();
        }
        else if (qName.equals("property"))
        {
            _currentPropertyName = attributes.getValue("name");
            _currentPropertyValue = new StringBuffer();
        }
    }
}
