package com.atlassian.user.impl.osuser;

import com.atlassian.user.*;
import com.opensymphony.user.ImmutableException;

import org.apache.log4j.Category;

public class OSUUser extends OSUEntity implements User
{
    private static final Category log = Category.getInstance(OSUUser.class);
    protected com.opensymphony.user.User osuser;


    public OSUUser(com.opensymphony.user.User osuser)
    {
        super(osuser);
        this.osuser = osuser;
    }

    public String getFullName()
    {
        try
        {
            return osuser.getFullName();
        }
        catch (NullPointerException e)
        {
            log.debug("No email address found for user with name [" + getName() + "]");
            return null;
        }
    }

    public String getEmail()
    {
        try
        {
            return osuser.getEmail();
        }
        catch (NullPointerException e)
        {
            log.debug("No email address found for user with name [" + getName() + "]");
            return null;
        }
    }

    public String toString()
    {
        StringBuffer sf = new StringBuffer();

        sf = sf.append("user: [").append(getName()).append("]\n");
        sf = sf.append("email: [").append(getEmail()).append("]\n");
        sf = sf.append("fullName: [").append(getFullName()).append("]\n");

        return sf.toString();
    }

    public void setEmail(String email)
    {
        osuser.setEmail(email);
    }

    public void setFullName(String fullName)
    {
        osuser.setFullName(fullName);
    }

    public void setPassword(String password)
    {
        try
        {
            osuser.setPassword(password);
        }
        catch (ImmutableException e)
        {
            log.error("Could not alter password: ", e);
            throw new IllegalStateException("Could not alter password: " + e);
        }
    }
}
