package com.atlassian.user.impl.ldap.search;

import net.sf.ldaptemplate.support.filter.Filter;
import com.atlassian.user.impl.ldap.LiteralFilter;
import com.atlassian.user.impl.ldap.properties.LdapSearchProperties;

public class DefaultLdapFilterFactory implements LdapFilterFactory
{
    private final LdapSearchProperties searchProperties;

    public DefaultLdapFilterFactory(LdapSearchProperties searchProperties)
    {
        this.searchProperties = searchProperties;
    }

    public Filter getGroupSearchFilter()
    {
        return new LiteralFilter(searchProperties.getGroupFilter());
    }

    public Filter getUserSearchFilter()
    {
        return new LiteralFilter(searchProperties.getUserFilter());
    }
}
