package com.atlassian.user.impl.ldap.properties;

public interface LdapMembershipProperties
{
    /**
     * @return <code>true</code> if the membership attribute specified in {@link #getMembershipAttribute()} is
     * on the group record (the most common situation), or <code>false</code> if the user record lists the memberships
     * of the user.
     */
    boolean isMembershipAttributeOnGroup();

    /**
     * @return attribute name of the attribute on an LDAP group or user which represents a user's membership in that group,
     * for example 'member'
     */
    String getMembershipAttribute();

    /**
     * @return <code>false</code> if the membership attribute specified in {@link #getMembershipAttribute()} is a
     * fully-qualified distinguished name (DN), or <code>true</code> if the membership attribute has an unqualified
     * identifier of the member or group.
     * @see LdapSearchProperties#getUsernameAttribute()
     * @see LdapSearchProperties#getGroupnameAttribute()
     */
    boolean isMembershipAttributeUnqualified();
}
