package com.atlassian.user.impl.hibernate;

import com.atlassian.user.impl.DefaultEntity;
import com.atlassian.user.ExternalEntity;

import java.util.Set;

public class DefaultHibernateExternalEntity extends DefaultEntity implements ExternalEntity
{
    protected String type;
    private Set groups;
    private long id;

    public DefaultHibernateExternalEntity(){}

    public String getType()
    {
        return type;
    }

    public void setType(String type)
    {
        this.type = type;
    }

    public Set getGroups()
    {
        return groups;
    }

    public void setGroups(Set groups)
    {
        this.groups = groups;
    }

    public long getId()
    {
        return id;
    }

    public void setId(long id)
    {
        this.id = id;
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (!(o instanceof DefaultHibernateExternalEntity)) return false;
        if (!super.equals(o)) return false;

        final DefaultHibernateExternalEntity defaultHibernateExternalEntity = (DefaultHibernateExternalEntity) o;

        if (id != defaultHibernateExternalEntity.id) return false;
        if (type != null ? !type.equals(defaultHibernateExternalEntity.type) : defaultHibernateExternalEntity.type != null) return false;

        return true;
    }

    public int hashCode()
    {
        int result = super.hashCode();
        result = 29 * result + (type != null ? type.hashCode() : 0);
        result = 29 * result + (int) (id ^ (id >>> 32));
        return result;
    }
}
