/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.memory.provider;

import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryProvider {
    private HashMap<String, User> users = new HashMap();
    private HashMap<String, Group> groups = new HashMap();
    private List<Membership> localMembership = new ArrayList<Membership>();
    private List<Membership> externalMembership = new ArrayList<Membership>();

    public Pager<String> getUserNames() {
        ArrayList<String> usernames = new ArrayList<String>();
        for (User user : this.users.values()) {
            usernames.add(user.getName());
        }
        return new DefaultPager<String>(usernames);
    }

    public Pager<User> getUsers() {
        return new DefaultPager<User>(new ArrayList<User>(this.users.values()));
    }

    public User getUser(String username) {
        return this.users.get(username);
    }

    public Pager<Group> getGroups() {
        return new DefaultPager<Group>(new ArrayList<Group>(this.groups.values()));
    }

    public Pager<Group> getGroups(User user) {
        ArrayList<Group> groupList = new ArrayList<Group>();
        for (Membership membership : this.localMembership) {
            if (!membership.getUser().equals(user)) continue;
            groupList.add(membership.getGroup());
        }
        return new DefaultPager<Group>(groupList);
    }

    public void addGroup(Group group) throws EntityException {
        this.groups.put(group.getName(), group);
    }

    public void removeGroup(Group group) throws EntityException, IllegalArgumentException {
        Membership membership;
        if (group == null || this.getGroup(group.getName()) == null) {
            throw new IllegalArgumentException("Group is null or doesn't exist in repository");
        }
        this.groups.remove(group.getName());
        Iterator<Membership> iter = this.localMembership.iterator();
        while (iter.hasNext()) {
            membership = iter.next();
            if (!membership.getGroup().equals(group)) continue;
            iter.remove();
        }
        iter = this.externalMembership.iterator();
        while (iter.hasNext()) {
            membership = iter.next();
            if (!membership.getGroup().equals(group)) continue;
            iter.remove();
        }
    }

    public Group getGroup(String groupName) {
        return this.groups.get(groupName);
    }

    public void addUser(User user) {
        this.users.put(user.getName(), user);
    }

    public void saveUser(User user) {
        this.users.put(user.getName(), user);
    }

    public void removeUser(User user) throws EntityException {
        Membership membership1;
        int i;
        this.users.remove(user.getName());
        for (i = 0; i < this.localMembership.size(); ++i) {
            membership1 = this.localMembership.get(i);
            if (!membership1.getUser().equals(user)) continue;
            this.localMembership.remove(membership1);
            if (this.localMembership.size() <= 0 || i == this.localMembership.size()) continue;
            --i;
        }
        for (i = 0; i < this.externalMembership.size(); ++i) {
            membership1 = this.externalMembership.get(i);
            if (!membership1.getUser().equals(user)) continue;
            this.externalMembership.remove(membership1);
            if (this.externalMembership.size() <= 0 || i == this.externalMembership.size()) continue;
            --i;
        }
    }

    public void addMembership(Group group, User user) {
        if (group == null) {
            throw new IllegalArgumentException("Cannot add membership for user [" + user + "] to a null group.");
        }
        if (user == null) {
            throw new IllegalArgumentException("Cannot add membership for null user to group [" + group + "]");
        }
        Membership membership1 = new Membership(group, user);
        List<Membership> check = this.isUserLocal(user) ? this.localMembership : this.externalMembership;
        for (Membership membership2 : check) {
            if (!membership2.equals(membership1)) continue;
            return;
        }
        check.add(membership1);
    }

    boolean isUserLocal(User user) {
        return this.users.get(user.getName()) != null;
    }

    public void removeMembership(Group group, User user) {
        List<Membership> check = this.isUserLocal(user) ? this.localMembership : this.externalMembership;
        for (int i = 0; i < check.size(); ++i) {
            Membership membership1 = check.get(i);
            if (!membership1.getUser().equals(user) || !membership1.getGroup().equals(group)) continue;
            check.remove(membership1);
        }
    }

    public Pager<String> getMemberNames(Group group) {
        ArrayList<String> memberNames = new ArrayList<String>();
        memberNames.addAll(this.getLocalMemberNamesAsList(group));
        memberNames.addAll(this.getExternalMemberNamesAsList(group));
        Collections.sort(memberNames, Collator.getInstance());
        return new DefaultPager<String>(memberNames);
    }

    public Pager<String> getExternalMemberNames(Group group) {
        List<String> members = this.getExternalMemberNamesAsList(group);
        return new DefaultPager<String>(members);
    }

    private List<String> getExternalMemberNamesAsList(Group group) {
        ArrayList<String> members = new ArrayList<String>();
        for (Membership membership : this.externalMembership) {
            if (!membership.getGroup().equals(group)) continue;
            members.add(membership.getUser().getName());
        }
        return members;
    }

    public Pager<User> getExternalMembers(Group group) {
        ArrayList<User> members = new ArrayList<User>();
        for (Membership membership : this.externalMembership) {
            if (!membership.getGroup().equals(group)) continue;
            members.add(membership.getUser());
        }
        return new DefaultPager<User>(members);
    }

    public Pager<String> getLocalMemberNames(Group group) {
        List<String> memberNames = this.getLocalMemberNamesAsList(group);
        Collections.sort(memberNames, Collator.getInstance());
        return new DefaultPager<String>(memberNames);
    }

    private List<String> getLocalMemberNamesAsList(Group group) {
        ArrayList<String> memberNames = new ArrayList<String>();
        for (Membership membership : this.localMembership) {
            if (!membership.getGroup().equals(group)) continue;
            memberNames.add(membership.getUser().getName());
        }
        return memberNames;
    }

    public Pager<User> getLocalMembers(Group group) {
        ArrayList<User> members = new ArrayList<User>();
        for (Membership membership : this.localMembership) {
            if (!membership.getGroup().equals(group)) continue;
            members.add(membership.getUser());
        }
        return new DefaultPager<User>(members);
    }

    public boolean hasMembership(Group group, User user) {
        if (this.isUserLocal(user)) {
            for (Membership membership : this.localMembership) {
                if (!membership.getGroup().equals(group) || !membership.getUser().equals(user)) continue;
                return true;
            }
        } else {
            for (Membership membership : this.externalMembership) {
                if (!membership.getGroup().equals(group) || !membership.getUser().equals(user)) continue;
                return true;
            }
        }
        return false;
    }

    class Membership {
        Group group;
        User user;

        public Membership(Group group, User user) {
            this.group = group;
            this.user = user;
        }

        public Group getGroup() {
            return this.group;
        }

        public User getUser() {
            return this.user;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Membership)) {
                return false;
            }
            Membership membership = (Membership)o;
            if (this.group != null ? !this.group.equals(membership.group) : membership.group != null) {
                return false;
            }
            return !(this.user != null ? !this.user.equals(membership.user) : membership.user != null);
        }

        public int hashCode() {
            int result = this.group != null ? this.group.hashCode() : 0;
            result = 29 * result + (this.user != null ? this.user.hashCode() : 0);
            return result;
        }
    }
}

