package com.atlassian.user.impl.memory.provider;

import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;

import java.text.Collator;
import java.util.*;

/**
 * @deprecated since 2.2 because it should not be used in production. Will be moved to test code in 3.0.
 */
public class MemoryProvider
{
    private HashMap<String, User> users;
    private HashMap<String, Group> groups;
    private List<Membership> localMembership;
    private List<Membership> externalMembership;

    class Membership
    {

        Group group;

        User user;

        public Membership(Group group, User user)
        {
            this.group = group;
            this.user = user;
        }

        public Group getGroup()
        {
            return group;
        }

        public User getUser()
        {
            return user;
        }

        public boolean equals(Object o)
        {
            if (this == o) return true;
            if (!(o instanceof Membership)) return false;

            final Membership membership = (Membership) o;

            if (group != null ? !group.equals(membership.group) : membership.group != null) return false;
            if (user != null ? !user.equals(membership.user) : membership.user != null) return false;

            return true;
        }

        public int hashCode()
        {
            int result;
            result = (group != null ? group.hashCode() : 0);
            result = 29 * result + (user != null ? user.hashCode() : 0);
            return result;
        }

    }

    public MemoryProvider()
    {
        users = new HashMap<String, User>();
        groups = new HashMap<String, Group>();
        localMembership = new ArrayList<Membership>();
        externalMembership = new ArrayList<Membership>();
    }

    public Pager<String> getUserNames()
    {
        List<String> usernames = new ArrayList<String>();

        for (User user : users.values())
        {
            usernames.add(user.getName());
        }

        return new DefaultPager<String>(usernames);
    }

    public Pager<User> getUsers()
    {
        return new DefaultPager<User>(new ArrayList<User>(users.values()));
    }

    public User getUser(String username)
    {
        return users.get(username);
    }

    public Pager<Group> getGroups()
    {
        return new DefaultPager<Group>(new ArrayList<Group>(groups.values()));
    }

    public Pager<Group> getGroups(User user)
    {
        ArrayList<Group> groupList = new ArrayList<Group>();

        for (Membership membership : localMembership)
        {
            if (membership.getUser().equals(user))
                groupList.add(membership.getGroup());
        }
        return new DefaultPager<Group>(groupList);
    }

    public void addGroup(Group group) throws EntityException
    {
        groups.put(group.getName(), group);
    }

    public void removeGroup(Group group) throws EntityException, IllegalArgumentException
    {
        if (group == null || getGroup(group.getName()) == null)
        {
            throw new IllegalArgumentException("Group is null or doesn't exist in repository");
        }

        groups.remove(group.getName());
        for (Iterator<Membership> iter = localMembership.iterator(); iter.hasNext();)
        {
            Membership membership = iter.next();
            if (membership.getGroup().equals(group))
                iter.remove();
        }
        for (Iterator<Membership> iter = externalMembership.iterator(); iter.hasNext();)
        {
            Membership membership = iter.next();
            if (membership.getGroup().equals(group))
                iter.remove();
        }
    }

    public Group getGroup(String groupName)
    {
        return groups.get(groupName);
    }

    public void addUser(User user)
    {
        users.put(user.getName(), user);
    }

    public void saveUser(User user)
    {
        users.put(user.getName(), user);
    }

    public void removeUser(User user) throws EntityException
    {
        users.remove(user.getName());

        for (int i = 0; i < localMembership.size(); i++)
        {
            Membership membership1 = localMembership.get(i);

            if (membership1.getUser().equals(user))
            {
                localMembership.remove(membership1);
                if (localMembership.size() > 0 && i != localMembership.size())
                    i--;
            }
        }

        for (int i = 0; i < externalMembership.size(); i++)
        {
            Membership membership1 = externalMembership.get(i);

            if (membership1.getUser().equals(user))
            {
                externalMembership.remove(membership1);
                if (externalMembership.size() > 0 && i != externalMembership.size())
                    i--;
            }
        }

    }


    /**
     * This might have been done at a higher level but it will generally be done at the provider level,
     * for non-memory implementations. It's good practice to situate it here, in the prototype.
     */
    public void addMembership(Group group, User user)
    {
        if (group == null)
            throw new IllegalArgumentException("Cannot add membership for user [" + user + "] to a null group.");

        if (user == null)
            throw new IllegalArgumentException("Cannot add membership for null user to group [" + group + "]");

        Membership membership1 = new Membership(group, user);

        List<Membership> check;
        if (isUserLocal(user))
            check = localMembership;
        else
            check = externalMembership;

        for (Membership membership2 : check)
        {
            if (membership2.equals(membership1))
                return;
        }

        check.add(membership1);
    }

    boolean isUserLocal(User user)
    {
        return (users.get(user.getName()) != null);
    }

    public void removeMembership(Group group, User user)
    {
        List<Membership> check;
        if (isUserLocal(user))
            check = localMembership;
        else
            check = externalMembership;

        for (int i = 0; i < check.size(); i++)
        {
            Membership membership1 = check.get(i);
            if (membership1.getUser().equals(user) && membership1.getGroup().equals(group))
                check.remove(membership1);
        }
    }

    public Pager<String> getMemberNames(Group group)
    {
        List<String> memberNames = new ArrayList<String>();
        memberNames.addAll(getLocalMemberNamesAsList(group));
        memberNames.addAll(getExternalMemberNamesAsList(group));
        Collections.sort(memberNames, Collator.getInstance());
        return new DefaultPager<String>(memberNames);
    }

    public Pager<String> getExternalMemberNames(Group group)
    {
        List<String> members = getExternalMemberNamesAsList(group);
        return new DefaultPager<String>(members);
    }

    private List<String> getExternalMemberNamesAsList(Group group)
    {
        List<String> members = new ArrayList<String>();

        for (Membership membership : externalMembership)
        {
            if (membership.getGroup().equals(group))
                members.add(membership.getUser().getName());
        }
        return members;
    }

    public Pager<User> getExternalMembers(Group group)
    {
        ArrayList<User> members = new ArrayList<User>();

        for (Membership membership : externalMembership)
        {
            if (membership.getGroup().equals(group))
                members.add(membership.getUser());
        }

        return new DefaultPager<User>(members);
    }

    public Pager<String> getLocalMemberNames(Group group)
    {
        List<String> memberNames = getLocalMemberNamesAsList(group);

        Collections.sort(memberNames, Collator.getInstance());
        return new DefaultPager<String>(memberNames);
    }

    private List<String> getLocalMemberNamesAsList(Group group)
    {
        List<String> memberNames = new ArrayList<String>();

        for (Membership membership : localMembership)
        {
            if (membership.getGroup().equals(group))
                memberNames.add(membership.getUser().getName());
        }
        return memberNames;
    }

    public Pager<User> getLocalMembers(Group group)
    {
        ArrayList<User> members = new ArrayList<User>();

        for (Membership membership : localMembership)
        {
            if (membership.getGroup().equals(group))
                members.add(membership.getUser());
        }

        return new DefaultPager<User>(members);
    }

    public boolean hasMembership(Group group, User user)
    {
        if (isUserLocal(user))
        {
            for (Membership membership : localMembership)
            {
                if (membership.getGroup().equals(group) && membership.getUser().equals(user))
                    return true;
            }
        }
        else
        {
            for (Membership membership : externalMembership)
            {
                if (membership.getGroup().equals(group) && membership.getUser().equals(user))
                    return true;
            }
        }

        return false;
    }
}