package com.atlassian.user.impl.memory;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.memory.provider.MemoryProvider;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.password.Credential;
import com.atlassian.user.security.password.PasswordEncryptor;
import com.atlassian.user.util.Assert;

/**
 * @deprecated since 2.2 because it should not be used in production. Will be moved to test code in 3.0.
 */
public class MemoryUserManager implements UserManager
{
    private final MemoryProvider provider;
    private final RepositoryIdentifier repository;
    private final PasswordEncryptor passwordEncryptor;

    public MemoryUserManager(RepositoryIdentifier repository, MemoryProvider provider, PasswordEncryptor passwordEncryptor)
    {
        this.provider = provider;
        this.repository = repository;
        this.passwordEncryptor = passwordEncryptor;
    }

    public Pager<User> getUsers()
    {
        return provider.getUsers();
    }

    public Pager<String> getUserNames() throws EntityException
    {
        return provider.getUserNames();
    }

    public User getUser(String username)
    {
        return provider.getUser(username);
    }

    public User createUser(String username) throws EntityException
    {
        return createUser(new DefaultUser(username), Credential.NONE);
    }

    public User createUser(User userTemplate, Credential credential) throws EntityException, UnsupportedOperationException, IllegalArgumentException
    {
        User existingUser = provider.getUser(userTemplate.getName());
        if (existingUser != null)
            throw new DuplicateEntityException("User already exists: [" + existingUser + "] in " + getRepository(existingUser));

        DefaultUser user = new DefaultUser(userTemplate.getName(), userTemplate.getFullName(), userTemplate.getEmail());
        user.setPassword(passwordEncryptor.getEncryptedValue(credential));
        provider.addUser(user);

        return user;
    }

    /**
     * Encrypts the plain password, sets it on the user, and saves the user.
     */
    public void alterPassword(User user, String plainTextPass) throws EntityException
    {
        user.setPassword(passwordEncryptor.encrypt(plainTextPass));
    }

    public void removeUser(com.atlassian.user.User user) throws EntityException
    {
        if(provider.getUser(user.getName())==null) {
            throw new IllegalArgumentException("User can not be found in this user manager: [" + user + "]");
        }
        provider.removeUser(user);
    }

    public boolean isReadOnly(User user)
    {
        return getUser(user.getName()) == null;
    }

    public void saveUser(User user) throws EntityException
    {
        Assert.notNull(user, "User must not be null");
        provider.saveUser(user);
    }

    /**
     * @return the {@link RepositoryIdentifier} which is managed by this instance.
     */
    public RepositoryIdentifier getIdentifier()
    {
        return repository;
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException
    {
        if (getUser(entity.getName()) == null)
            return null;

        return repository;
    }

    public boolean isCreative()
    {
        return true;
    }
}
