/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.test;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public final class ApplicationPropertiesImpl
implements ApplicationProperties {
    private static final ApplicationProperties STANDARD = new ApplicationPropertiesImpl(ApplicationPropertiesImpl.getStandardBaseUrl());
    private final String baseUrl;

    public ApplicationPropertiesImpl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public static ApplicationProperties getStandardApplicationProperties() {
        return STANDARD;
    }

    private static String getStandardBaseUrl() {
        return System.getProperty("baseurl", "http://localhost:3990/it");
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getBaseUrl(UrlMode urlMode) {
        return this.getBaseUrl();
    }

    public String getDisplayName() {
        return "Atlassian Integration Tester";
    }

    public String getPlatformId() {
        return this.getDisplayName();
    }

    public String getVersion() {
        return System.getProperty("version");
    }

    public Date getBuildDate() {
        String timestamp = System.getProperty("timestamp");
        if (timestamp != null) {
            try {
                return DateFormat.getDateTimeInstance().parse(timestamp);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public String getBuildNumber() {
        return System.getProperty("buildNumber");
    }

    public File getHomeDirectory() {
        return null;
    }

    public String getPropertyValue(String key) {
        return null;
    }
}

