/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.role.jira;

import com.atlassian.plugin.Plugin;
import com.atlassian.pocketknife.api.lifecycle.modules.DynamicModuleDescriptorFactory;
import com.atlassian.pocketknife.api.lifecycle.modules.ModuleRegistrationHandle;
import com.atlassian.upm.license.role.jira.DynamicGlobalPermissionService;
import com.atlassian.upm.license.role.spi.LicensingRoleCreationFailedException;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.tree.DefaultAttribute;
import org.dom4j.tree.DefaultElement;

public class DynamicGlobalPermissionServiceImpl
implements DynamicGlobalPermissionService {
    private static final String GLOBAL_PERMISSION_ROOT_NAME = "global-permission";
    private final DynamicModuleDescriptorFactory dynamicModuleDescriptorFactory;

    public DynamicGlobalPermissionServiceImpl(DynamicModuleDescriptorFactory dynamicModuleDescriptorFactory) {
        this.dynamicModuleDescriptorFactory = dynamicModuleDescriptorFactory;
    }

    @Override
    public ModuleRegistrationHandle dynamicallyCreatePermission(Plugin plugin, String key, String nameI18nKey, String descriptionI18nKey) throws LicensingRoleCreationFailedException {
        try {
            Element globalPermissionElement = this.createElementForGlobalPermission(key, nameI18nKey, descriptionI18nKey);
            return this.dynamicModuleDescriptorFactory.loadModules(plugin, globalPermissionElement);
        }
        catch (Exception e) {
            throw new LicensingRoleCreationFailedException("Failed to create global permission", (Throwable)e);
        }
    }

    private Element createElementForGlobalPermission(String key, String nameI18nKey, String descriptionI18nKey) {
        DefaultElement rootElement = new DefaultElement(GLOBAL_PERMISSION_ROOT_NAME);
        DefaultAttribute keyAttribute = new DefaultAttribute("key", key);
        DefaultAttribute nameAttribute = new DefaultAttribute("i18n-name-key", nameI18nKey);
        DefaultAttribute descriptionAttribute = new DefaultAttribute("i18n-description-key", descriptionI18nKey);
        DefaultAttribute anonymousAllowedAttribute = new DefaultAttribute("anonymous-allowed", "false");
        rootElement.add((Attribute)keyAttribute);
        rootElement.add((Attribute)nameAttribute);
        rootElement.add((Attribute)descriptionAttribute);
        rootElement.add((Attribute)anonymousAllowedAttribute);
        return rootElement;
    }
}

