/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.role.confluence;

import com.atlassian.fugue.Option;
import com.atlassian.upm.license.role.spi.LicensingRoleCreationFailedException;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceRoleBasedLicenseManager {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceRoleBasedLicenseManager.class);
    private final GroupManager groupManager;
    private final UserManager userManager;

    public ConfluenceRoleBasedLicenseManager(GroupManager groupManager, UserManager userManager) {
        this.groupManager = (GroupManager)Preconditions.checkNotNull((Object)groupManager, (Object)"groupManager");
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
    }

    protected Group createGroup(String groupName) throws LicensingRoleCreationFailedException {
        try {
            return this.groupManager.createGroup(groupName);
        }
        catch (EntityException e) {
            throw new LicensingRoleCreationFailedException((Throwable)e);
        }
    }

    protected Option<User> getUser(String userKey) {
        try {
            return Option.option((Object)this.userManager.getUser(userKey));
        }
        catch (EntityException e) {
            this.logException("Failed to look up user with userKey: " + userKey, (Exception)((Object)e));
            return Option.none();
        }
    }

    protected Option<Group> getGroup(String groupName) {
        try {
            return Option.option((Object)this.groupManager.getGroup(groupName));
        }
        catch (EntityException e) {
            this.logException("Failed to look up group with name: " + groupName, (Exception)((Object)e));
            return Option.none();
        }
    }

    protected boolean hasMembership(Group group, String userKey) {
        try {
            Iterator i$ = this.getUser(userKey).iterator();
            if (i$.hasNext()) {
                User user = (User)i$.next();
                return this.groupManager.hasMembership(group, user);
            }
        }
        catch (EntityException e) {
            this.logException("Failed to look up user with userKey: " + userKey, (Exception)((Object)e));
        }
        return false;
    }

    protected int getMembershipCount(String groupName) {
        try {
            return Iterables.size((Iterable)this.groupManager.getMemberNames(this.groupManager.getGroup(groupName)));
        }
        catch (EntityException e) {
            this.logException("Failed to look up group membership count with name: " + groupName, (Exception)((Object)e));
            return 0;
        }
    }

    private void logException(String errorMessage, Exception e) {
        log.warn(errorMessage);
        log.debug(errorMessage, (Throwable)e);
    }
}

