/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.storage.lib;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginController;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.upm.license.storage.lib.PluginArtifactFactory;
import com.atlassian.upm.license.storage.lib.VersionChecker;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class PluginLicenseStoragePluginInstaller
implements InitializingBean {
    static final String UPM_PLUGIN_KEY = "com.atlassian.upm.atlassian-universal-plugin-manager-plugin";
    static final String PLUGIN_LICENSE_STORAGE_PLUGIN_KEY = "com.atlassian.upm.plugin-license-storage-plugin";
    private static final Logger log = LoggerFactory.getLogger(PluginLicenseStoragePluginInstaller.class);
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;
    private final TransactionTemplate txTemplate;

    public PluginLicenseStoragePluginInstaller(PluginAccessor pluginAccessor, PluginController pluginController, TransactionTemplate txTemplate) {
        this.pluginAccessor = (PluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor, (Object)"pluginAccessor");
        this.pluginController = (PluginController)Preconditions.checkNotNull((Object)pluginController, (Object)"pluginController");
        this.txTemplate = (TransactionTemplate)Preconditions.checkNotNull((Object)txTemplate, (Object)"txTemplate");
    }

    private boolean installStoragePlugin(final PluginArtifact pluginArtifact) {
        if (pluginArtifact == null) {
            log.error("Could not find the artifact needed to install the Plugin License Storage plugin. Did you use maven-dependency-plugin to include it within your plugin?");
            return false;
        }
        return (Boolean)this.txTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction() {
                String pluginKey = PluginLicenseStoragePluginInstaller.this.pluginController.installPlugin(pluginArtifact);
                if (pluginKey == null) {
                    log.error("Plugin failed to install: " + pluginArtifact.getName());
                    return false;
                }
                return true;
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        try {
            if (!VersionChecker.isUpm201OrLaterInstalled(this.pluginAccessor)) {
                VersionChecker.PluginState pluginState = VersionChecker.getPluginLicenseStoragePluginState(this.pluginAccessor, "2.10");
                if (!pluginState.isSufficientVersionInstalled() && !this.installStoragePlugin(PluginArtifactFactory.fromFile("plugin-license-storage-plugin.jar"))) {
                    log.error("Error while installing the Plugin License Storage plugin. Is the artifact on your plugin's classpath?");
                }
                if (!pluginState.isEnabled()) {
                    try {
                        this.pluginController.enablePlugin(PLUGIN_LICENSE_STORAGE_PLUGIN_KEY);
                    }
                    catch (Exception e) {
                        log.warn("Failed to enabled license storage plugin", (Throwable)e);
                    }
                }
            }
        }
        catch (Throwable th) {
            log.error("Failed to install or enable the Plugin License Storage plugin version 2.10", th);
        }
    }
}

