package com.atlassian.upm.license.storage.lib;

/**
 * Thrown when a user attempts a license-related action to which he or she does not have access.
 * The primary case where this would be thrown involves a non-administrator user trying to either
 * access or update a plugin license.
 *
 * @since 2.2.1
 */
public class PluginLicenseStoragePluginPermissionDeniedException extends RuntimeException
{
    public PluginLicenseStoragePluginPermissionDeniedException(String username)
    {
        super("User '" + username + "' attempted an unpermitted license action.");
    }
}
