/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.model;

import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.model.Application;
import com.atlassian.marketplace.client.model.ApplicationSummary;
import com.atlassian.marketplace.client.model.ApplicationVersion;
import com.atlassian.marketplace.client.model.Banner;
import com.atlassian.marketplace.client.model.Icons;
import com.atlassian.marketplace.client.model.Image;
import com.atlassian.marketplace.client.model.KeyValuePair;
import com.atlassian.marketplace.client.model.LicenseType;
import com.atlassian.marketplace.client.model.Links;
import com.atlassian.marketplace.client.model.MarketplaceType;
import com.atlassian.marketplace.client.model.Modification;
import com.atlassian.marketplace.client.model.Plugin;
import com.atlassian.marketplace.client.model.PluginCategory;
import com.atlassian.marketplace.client.model.PluginMedia;
import com.atlassian.marketplace.client.model.PluginSummary;
import com.atlassian.marketplace.client.model.PluginVersion;
import com.atlassian.marketplace.client.model.Pricing;
import com.atlassian.marketplace.client.model.PricingItem;
import com.atlassian.marketplace.client.model.Review;
import com.atlassian.marketplace.client.model.ReviewResponse;
import com.atlassian.marketplace.client.model.ReviewSummary;
import com.atlassian.marketplace.client.model.Reviews;
import com.atlassian.marketplace.client.model.Screenshot;
import com.atlassian.marketplace.client.model.UserSummary;
import com.atlassian.marketplace.client.model.Vendor;
import com.atlassian.marketplace.client.model.VersionCompatibility;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.api.util.Pair;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class ModelBuilders {
    public static String DEFAULT_STRING = "DefaultValue";
    public static Date DEFAULT_DATE = new Date(0L);
    public static int DEFAULT_INT = Integer.MAX_VALUE;
    public static long DEFAULT_LONG = Long.MAX_VALUE;
    public static URI DEFAULT_URI = URI.create("http://default/uri");
    public static int DEFAULT_STARS = 3;
    public static float DEFAULT_PRICE = 100.0f;

    public static ApplicationBuilder application() {
        return new ApplicationBuilder();
    }

    public static ApplicationBuilder application(Application from) {
        return ((ApplicationBuilder)ModelBuilders.application().links(from.getLinks())).key(from.getKey()).name(from.getName()).order(from.getOrder()).pluginCount(from.getPluginCount()).versions(from.getVersions()).categories(from.getCategories());
    }

    public static ApplicationSummaryBuilder applicationSummary() {
        return new ApplicationSummaryBuilder();
    }

    public static ApplicationSummaryBuilder applicationSummary(ApplicationSummary from) {
        return ((ApplicationSummaryBuilder)ModelBuilders.applicationSummary().links(from.getLinks())).key(from.getKey()).name(from.getName()).order(from.getOrder()).pluginCount(from.getPluginCount());
    }

    public static ApplicationSummaryBuilder applicationSummary(Application from) {
        return ((ApplicationSummaryBuilder)ModelBuilders.applicationSummary().links(from.getLinks())).key(from.getKey()).name(from.getName()).order(from.getOrder()).pluginCount(from.getPluginCount());
    }

    public static ApplicationVersionBuilder applicationVersion() {
        return new ApplicationVersionBuilder();
    }

    public static ApplicationVersionBuilder applicationVersion(ApplicationVersion from) {
        return ((ApplicationVersionBuilder)ModelBuilders.applicationVersion().links(from.getLinks())).buildNumber(from.getBuildNumber()).published(from.isPublished()).releaseDate(from.getReleaseDate()).version(from.getVersion());
    }

    public static BannerBuilder banner() {
        return new BannerBuilder();
    }

    public static IconsBuilder icons() {
        return new IconsBuilder();
    }

    public static IconsBuilder icons(Icons from) {
        return ModelBuilders.icons().defaultIcon(from.getDefaultIcon()).tinyIcon(from.getTinyIcon());
    }

    public static ImageBuilder image() {
        return new ImageBuilder();
    }

    public static ImageBuilder image(Image from) {
        return ((ImageBuilder)ModelBuilders.image().links(from.getLinks())).altText(from.getAltText()).height(from.getHeight()).width(from.getWidth());
    }

    public static LicenseTypeBuilder licenseType() {
        return new LicenseTypeBuilder();
    }

    public static LicenseTypeBuilder licenseType(LicenseType from) {
        return ((LicenseTypeBuilder)ModelBuilders.licenseType().links(from.getLinks())).id(from.getId()).name(from.getName());
    }

    public static LinksBuilder links() {
        return new LinksBuilder();
    }

    public static LinksBuilder links(Links links) {
        return ModelBuilders.links().put(links);
    }

    public static ModificationBuilder modification() {
        return new ModificationBuilder();
    }

    public static ModificationBuilder modification(Modification from) {
        return ModelBuilders.modification().by(from.getBy()).date(from.getDate());
    }

    public static PluginBuilder plugin() {
        return new PluginBuilder();
    }

    public static PluginBuilder plugin(Plugin from) {
        return ((PluginBuilder)ModelBuilders.plugin().links(from.getLinks())).categories(from.getCategories()).compatibleApplications(from.getCompatibleApplications()).creationDate(from.getCreationDate()).deployable(from.isDeployable()).description(from.getDescription()).downloadCount(from.getDownloadCount()).lastModified(from.getLastModified()).media(from.getMedia()).name(from.getName()).oldVersion(from.isOldVersion()).pluginKey(from.getPluginKey()).pricing(from.getPricing()).reviews(from.getReviews()).reviewSummary(from.getReviewSummary()).summary(from.getSummary()).vendor(from.getVendor()).version(from.getVersion()).versions(from.getVersions()).versionsCount(from.getVersionCount());
    }

    public static PluginCategoryBuilder pluginCategory() {
        return new PluginCategoryBuilder();
    }

    public static PluginCategoryBuilder pluginCategory(PluginCategory from) {
        return ((PluginCategoryBuilder)ModelBuilders.pluginCategory().links(from.getLinks())).name(from.getName());
    }

    public static PluginMediaBuilder pluginMedia() {
        return new PluginMediaBuilder();
    }

    public static PluginMediaBuilder pluginMedia(PluginMedia from) {
        return ModelBuilders.pluginMedia().banner(from.getBanner()).icons(from.getIcons()).screenshots(from.getScreenshots()).youtubeId(from.getYoutubeId());
    }

    public static PluginSummaryBuilder pluginSummary() {
        return new PluginSummaryBuilder();
    }

    public static PluginSummaryBuilder pluginSummary(PluginSummary from) {
        return ((PluginSummaryBuilder)ModelBuilders.pluginSummary().links(from.getLinks())).categories(from.getCategories()).compatibleApplications(from.getCompatibleApplications()).downloadCount(from.getDownloadCount()).lastModified(from.getLastModified()).lastReleasedDate(from.getLastReleasedDate()).icons(from.getIcons()).name(from.getName()).pluginKey(from.getPluginKey()).pricing(from.getPricing()).reviewSummary(from.getReviewSummary()).summary(from.getSummary()).vendor(from.getVendor()).version(from.getVersion());
    }

    public static PluginSummaryBuilder pluginSummary(Plugin from) {
        return ((PluginSummaryBuilder)ModelBuilders.pluginSummary().links(from.getLinks())).categories(from.getCategories()).compatibleApplications(from.getCompatibleApplications()).downloadCount(from.getDownloadCount()).lastModified(from.getLastModified()).icons(from.getMedia().getIcons()).name(from.getName()).pluginKey(from.getPluginKey()).pricing(from.getPricing()).reviewSummary(from.getReviewSummary()).summary(from.getSummary()).vendor(from.getVendor()).version(from.getVersion());
    }

    public static PluginVersionBuilder pluginVersion() {
        return new PluginVersionBuilder();
    }

    public static PluginVersionBuilder pluginVersion(PluginVersion from) {
        return ((PluginVersionBuilder)ModelBuilders.pluginVersion().links(from.getLinks())).compatibilities(from.getCompatibilities()).buildNumber(from.getBuildNumber()).compatibleApplications(from.getCompatibleApplications()).deployable(from.isDeployable()).license(from.getLicense()).marketplaceType(from.getMarketplaceType()).marketplaceTypeTooltip(from.getMarketplaceTypeTooltip()).pluginSystemVersion(from.getPluginSystemVersion()).published(from.isPublished()).releaseDate(from.getReleaseDate()).releasedBy(from.getReleasedBy()).releaseFocus(from.getReleaseFocus()).releaseNotes(from.getReleaseNotes()).screenshots(from.getScreenshots()).stable(from.isStable()).summary(from.getSummary()).supportType(from.getSupportType()).version(from.getVersion());
    }

    public static PricingBuilder pricing() {
        return new PricingBuilder();
    }

    public static PricingBuilder pricing(Pricing from) {
        return ((PricingBuilder)ModelBuilders.pricing().links(from.getLinks())).expertDiscountOptOut(from.isExpertDiscountOptOut()).items(from.getItems()).lastModified(from.getLastModified()).legacyItems(from.getLegacyItems()).legacyMaxVersion(from.getLegacyMaxVersion()).nonLegacyStartVersion(from.getNonLegacyStartVersion()).parent(from.getParent());
    }

    public static PricingItemBuilder pricingItem() {
        return new PricingItemBuilder();
    }

    public static PricingItemBuilder pricingItem(PricingItem from) {
        return ModelBuilders.pricingItem().description(from.getDescription()).enterprise(from.isEnterprise()).id(from.getId()).legacyDisplay(from.isLegacyDisplay()).licenseType(from.getLicenseType()).saleType(from.getSaleType()).starter(from.isStarter()).unitCount(from.getUnitCount()).unitDescription(from.getUnitDescription()).usdAmount(from.getUsdAmount());
    }

    public static ReviewBuilder review() {
        return new ReviewBuilder();
    }

    public static ReviewBuilder review(Review from) {
        return ModelBuilders.review().author(from.getAuthor()).date(from.getDate()).pluginName(from.getPluginName()).response(from.getResponse()).review(from.getReview()).stars(from.getStars());
    }

    public static ReviewResponseBuilder reviewResponse() {
        return new ReviewResponseBuilder();
    }

    public static ReviewResponseBuilder reviewResponse(ReviewResponse from) {
        return ModelBuilders.reviewResponse().response(from.getResponse());
    }

    public static ReviewsBuilder reviews() {
        return new ReviewsBuilder();
    }

    public static ReviewsBuilder reviews(Reviews from) {
        return ((ReviewsBuilder)ModelBuilders.reviews().links(from.getLinks())).reviews(from.getReviews());
    }

    public static ReviewSummaryBuilder reviewSummary() {
        return new ReviewSummaryBuilder();
    }

    public static ReviewSummaryBuilder reviewSummary(ReviewSummary from) {
        return ((ReviewSummaryBuilder)ModelBuilders.reviewSummary().links(from.getLinks())).averageStars(from.getAverageStars()).count(from.getCount());
    }

    public static ScreenshotBuilder screenshot() {
        return new ScreenshotBuilder();
    }

    public static ScreenshotBuilder screenshot(Screenshot from) {
        return ModelBuilders.screenshot().carouselImage(from.getCarouselImage()).image(from.getImage()).name(from.getName());
    }

    public static UserSummaryBuilder userSummary() {
        return new UserSummaryBuilder();
    }

    public static UserSummaryBuilder userSummary(UserSummary from) {
        return ((UserSummaryBuilder)ModelBuilders.userSummary().links(from.getLinks())).email(from.getEmail()).id(from.getId()).name(from.getName());
    }

    public static VendorBuilder vendor() {
        return new VendorBuilder();
    }

    public static VendorBuilder vendor(Vendor from) {
        return ((VendorBuilder)ModelBuilders.vendor().links(from.getLinks())).email(from.getEmail()).id(from.getId()).name(from.getName()).otherContactDetails(from.getOtherContactDetails()).phone(from.getPhone());
    }

    public static VersionCompatibilityBuilder versionCompatibility() {
        return new VersionCompatibilityBuilder();
    }

    public static VersionCompatibilityBuilder versionCompatibility(VersionCompatibility from) {
        return ModelBuilders.versionCompatibility().applicationName(from.getApplicationName()).max(from.getMax()).min(from.getMin());
    }

    private static String nullableString(Option<String> s) {
        return (String)s.getOrElse((Object)null);
    }

    public static class VersionCompatibilityBuilder {
        private String applicationName = DEFAULT_STRING;
        private VersionCompatibility.VersionAndBuildNumber min = new VersionCompatibility.VersionAndBuildNumber(DEFAULT_STRING, 0L);
        private VersionCompatibility.VersionAndBuildNumber max = new VersionCompatibility.VersionAndBuildNumber(DEFAULT_STRING, Long.MAX_VALUE);

        public VersionCompatibility build() {
            return new VersionCompatibility(this.applicationName, this.min, this.max);
        }

        public VersionCompatibilityBuilder applicationName(String applicationName) {
            this.applicationName = (String)Preconditions.checkNotNull((Object)applicationName);
            return this;
        }

        public VersionCompatibilityBuilder min(VersionCompatibility.VersionAndBuildNumber min) {
            this.min = (VersionCompatibility.VersionAndBuildNumber)Preconditions.checkNotNull((Object)min);
            return this;
        }

        public VersionCompatibilityBuilder max(VersionCompatibility.VersionAndBuildNumber max) {
            this.max = (VersionCompatibility.VersionAndBuildNumber)Preconditions.checkNotNull((Object)max);
            return this;
        }
    }

    public static class VendorBuilder
    extends BuilderWithLinks<VendorBuilder> {
        private long id = DEFAULT_LONG;
        private String name = DEFAULT_STRING;
        private Option<String> email = Option.none();
        private Option<String> phone = Option.none();
        private Option<String> otherContactDetails = Option.none();

        public Vendor build() {
            return new Vendor(this.links.build(), this.id, this.name, ModelBuilders.nullableString((Option<String>)this.email), ModelBuilders.nullableString((Option<String>)this.phone), ModelBuilders.nullableString((Option<String>)this.otherContactDetails));
        }

        public VendorBuilder id(long id) {
            this.id = id;
            return this;
        }

        public VendorBuilder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        public VendorBuilder email(Option<String> email) {
            this.email = (Option)Preconditions.checkNotNull(email);
            return this;
        }

        public VendorBuilder phone(Option<String> phone) {
            this.phone = (Option)Preconditions.checkNotNull(phone);
            return this;
        }

        public VendorBuilder otherContactDetails(Option<String> otherContactDetails) {
            this.otherContactDetails = (Option)Preconditions.checkNotNull(otherContactDetails);
            return this;
        }
    }

    public static class UserSummaryBuilder
    extends BuilderWithLinks<UserSummaryBuilder> {
        private long id = DEFAULT_LONG;
        private String name = DEFAULT_STRING;
        private Option<String> email = Option.none();

        public UserSummary build() {
            return new UserSummary(this.links.build(), this.id, this.name, ModelBuilders.nullableString((Option<String>)this.email));
        }

        public UserSummaryBuilder id(long id) {
            this.id = id;
            return this;
        }

        public UserSummaryBuilder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        public UserSummaryBuilder email(Option<String> email) {
            this.email = (Option)Preconditions.checkNotNull(email);
            return this;
        }
    }

    public static class ScreenshotBuilder {
        private String name = DEFAULT_STRING;
        private Image image = ModelBuilders.image().build();
        private Option<Image> carouselImage = Option.none();

        public Screenshot build() {
            return new Screenshot(this.name, this.image, (Image)this.carouselImage.getOrElse((Object)null));
        }

        public ScreenshotBuilder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        public ScreenshotBuilder image(Image image) {
            this.image = (Image)Preconditions.checkNotNull((Object)image);
            return this;
        }

        public ScreenshotBuilder carouselImage(Option<Image> carouselImage) {
            this.carouselImage = (Option)Preconditions.checkNotNull(carouselImage);
            return this;
        }
    }

    public static class ReviewSummaryBuilder
    extends BuilderWithLinks<ReviewSummaryBuilder> {
        private float averageStars = DEFAULT_STARS;
        private int count = DEFAULT_INT;

        public ReviewSummary build() {
            return new ReviewSummary(this.links.build(), Float.valueOf(this.averageStars), this.count);
        }

        public ReviewSummaryBuilder averageStars(float averageStars) {
            this.averageStars = averageStars;
            return this;
        }

        public ReviewSummaryBuilder count(int count) {
            this.count = count;
            return this;
        }
    }

    public static class ReviewsBuilder
    extends BuilderWithLinks<ReviewsBuilder> {
        private Collection<Review> reviews = ImmutableList.of();

        public Reviews build() {
            return new Reviews(this.links.build(), this.reviews);
        }

        public ReviewsBuilder reviews(Iterable<Review> reviews) {
            this.reviews = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(reviews)));
            return this;
        }
    }

    public static class ReviewResponseBuilder
    extends BuilderWithLinks<ReviewResponseBuilder> {
        private String response = DEFAULT_STRING;

        public ReviewResponse build() {
            return new ReviewResponse(this.links.build(), this.response);
        }

        public ReviewResponseBuilder response(String response) {
            this.response = (String)Preconditions.checkNotNull((Object)response);
            return this;
        }
    }

    public static class ReviewBuilder
    extends BuilderWithLinks<ReviewBuilder> {
        private String pluginName = DEFAULT_STRING;
        private Option<UserSummary> author = Option.none();
        private int stars = DEFAULT_STARS;
        private Date date = DEFAULT_DATE;
        private Option<String> review = Option.none();
        private Option<ReviewResponse> response = Option.none();

        public Review build() {
            return new Review(this.links.build(), this.pluginName, (UserSummary)this.author.getOrElse((Object)null), this.stars, this.date, ModelBuilders.nullableString((Option<String>)this.review), (ReviewResponse)this.response.getOrElse((Object)null));
        }

        public ReviewBuilder pluginName(String pluginName) {
            this.pluginName = (String)Preconditions.checkNotNull((Object)pluginName);
            return this;
        }

        public ReviewBuilder author(Option<UserSummary> author) {
            this.author = (Option)Preconditions.checkNotNull(author);
            return this;
        }

        public ReviewBuilder stars(int stars) {
            this.stars = stars;
            return this;
        }

        public ReviewBuilder date(Date date) {
            this.date = (Date)Preconditions.checkNotNull((Object)date);
            return this;
        }

        public ReviewBuilder review(Option<String> review) {
            this.review = (Option)Preconditions.checkNotNull(review);
            return this;
        }

        public ReviewBuilder response(Option<ReviewResponse> response) {
            this.response = (Option)Preconditions.checkNotNull(response);
            return this;
        }
    }

    public static class PricingItemBuilder {
        private long id = DEFAULT_LONG;
        private Option<String> description = Option.none();
        private Option<String> unitDescription = Option.none();
        private float usdAmount = DEFAULT_PRICE;
        private int unitCount = DEFAULT_INT;
        private boolean enterprise = false;
        private boolean starter = false;
        private String saleType = DEFAULT_STRING;
        private String licenseType = DEFAULT_STRING;
        private boolean legacyDisplay = false;

        public PricingItem build() {
            return new PricingItem(this.id, ModelBuilders.nullableString((Option<String>)this.description), ModelBuilders.nullableString((Option<String>)this.unitDescription), Float.valueOf(this.usdAmount), this.unitCount, this.enterprise, this.starter, this.saleType, this.licenseType, this.legacyDisplay);
        }

        public PricingItemBuilder id(long id) {
            this.id = id;
            return this;
        }

        public PricingItemBuilder description(Option<String> description) {
            this.description = (Option)Preconditions.checkNotNull(description);
            return this;
        }

        public PricingItemBuilder unitDescription(Option<String> unitDescription) {
            this.unitDescription = (Option)Preconditions.checkNotNull(unitDescription);
            return this;
        }

        public PricingItemBuilder usdAmount(float usdAmount) {
            this.usdAmount = usdAmount;
            return this;
        }

        public PricingItemBuilder unitCount(int unitCount) {
            this.unitCount = unitCount;
            return this;
        }

        public PricingItemBuilder enterprise(boolean enterprise) {
            this.enterprise = enterprise;
            return this;
        }

        public PricingItemBuilder starter(boolean starter) {
            this.starter = starter;
            return this;
        }

        public PricingItemBuilder saleType(String saleType) {
            this.saleType = (String)Preconditions.checkNotNull((Object)saleType);
            return this;
        }

        public PricingItemBuilder licenseType(String licenseType) {
            this.licenseType = (String)Preconditions.checkNotNull((Object)licenseType);
            return this;
        }

        public PricingItemBuilder legacyDisplay(boolean legacyDisplay) {
            this.legacyDisplay = legacyDisplay;
            return this;
        }
    }

    public static class PricingBuilder
    extends BuilderWithLinks<PricingBuilder> {
        private Collection<PricingItem> items = ImmutableList.of();
        private boolean expertDiscountOptOut = false;
        private Option<String> parent = Option.none();
        private Option<Date> lastModified = Option.none();
        private Collection<PricingItem> legacyItems = ImmutableList.of();
        private Option<String> nonLegacyStartVersion = Option.none();
        private Option<String> legacyMaxVersion = Option.none();

        public Pricing build() {
            return new Pricing(this.links.build(), this.items, this.expertDiscountOptOut, ModelBuilders.nullableString((Option<String>)this.parent), (Date)this.lastModified.getOrElse((Object)null), this.legacyItems, ModelBuilders.nullableString((Option<String>)this.nonLegacyStartVersion), ModelBuilders.nullableString((Option<String>)this.legacyMaxVersion));
        }

        public PricingBuilder items(Iterable<PricingItem> items) {
            this.items = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(items)));
            return this;
        }

        public PricingBuilder expertDiscountOptOut(boolean optOut) {
            this.expertDiscountOptOut = optOut;
            return this;
        }

        public PricingBuilder parent(Option<String> parent) {
            this.parent = (Option)Preconditions.checkNotNull(parent);
            return this;
        }

        public PricingBuilder lastModified(Option<Date> lastModified) {
            this.lastModified = (Option)Preconditions.checkNotNull(lastModified);
            return this;
        }

        public PricingBuilder legacyItems(Iterable<PricingItem> legacyItems) {
            this.legacyItems = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(legacyItems)));
            return this;
        }

        public PricingBuilder nonLegacyStartVersion(Option<String> nonLegacyStartVersion) {
            this.nonLegacyStartVersion = (Option)Preconditions.checkNotNull(nonLegacyStartVersion);
            return this;
        }

        public PricingBuilder legacyMaxVersion(Option<String> legacyMaxVersion) {
            this.legacyMaxVersion = (Option)Preconditions.checkNotNull(legacyMaxVersion);
            return this;
        }
    }

    public static class PluginVersionBuilder
    extends BuilderWithLinks<PluginVersionBuilder> {
        private long buildNumber = DEFAULT_LONG;
        private Date releaseDate = DEFAULT_DATE;
        private Option<String> releasedBy = Option.none();
        private Option<String> releaseFocus = Option.none();
        private boolean stable = true;
        private String status = DEFAULT_STRING;
        private LicenseType license = ModelBuilders.licenseType().build();
        private String version = DEFAULT_STRING;
        private boolean deployable = true;
        private String supportType = DEFAULT_STRING;
        private String pluginSystemVersion = DEFAULT_STRING;
        private Option<String> releaseNotes = Option.none();
        private Option<String> summary = Option.none();
        private Collection<ApplicationSummary> compatibleApplications = ImmutableList.of();
        private Collection<VersionCompatibility> compatibilities = ImmutableList.of();
        private MarketplaceType marketplaceType = MarketplaceType.FREE;
        private String marketplaceTypeTooltip = DEFAULT_STRING;
        private Collection<Screenshot> screenshots = ImmutableList.of();
        private Option<String> youtubeId = Option.none();

        public PluginVersionBuilder() {
            this.links.put("alternate", DEFAULT_URI);
        }

        public PluginVersion build() {
            return new PluginVersion(this.links.build(), this.buildNumber, this.releaseDate, ModelBuilders.nullableString((Option<String>)this.releasedBy), ModelBuilders.nullableString((Option<String>)this.releaseFocus), this.stable, this.status, this.license, this.version, this.deployable, this.supportType, this.pluginSystemVersion, ModelBuilders.nullableString((Option<String>)this.releaseNotes), ModelBuilders.nullableString((Option<String>)this.summary), this.compatibleApplications, this.compatibilities, (Map<String, String>)ImmutableMap.of((Object)"type", (Object)this.marketplaceType.getDisplayName(), (Object)"tooltip", (Object)this.marketplaceTypeTooltip), this.screenshots, ModelBuilders.nullableString((Option<String>)this.youtubeId));
        }

        public PluginVersionBuilder buildNumber(long buildNumber) {
            this.buildNumber = buildNumber;
            return this;
        }

        public PluginVersionBuilder published(boolean published) {
            this.status = published ? "Published" : "Draft";
            return this;
        }

        public PluginVersionBuilder releaseDate(Date date) {
            this.releaseDate = (Date)Preconditions.checkNotNull((Object)date);
            return this;
        }

        public PluginVersionBuilder releasedBy(Option<String> releasedBy) {
            this.releasedBy = (Option)Preconditions.checkNotNull(releasedBy);
            return this;
        }

        public PluginVersionBuilder releaseFocus(Option<String> releaseFocus) {
            this.releaseFocus = (Option)Preconditions.checkNotNull(releaseFocus);
            return this;
        }

        public PluginVersionBuilder stable(boolean stable) {
            this.stable = stable;
            return this;
        }

        public PluginVersionBuilder status(String status) {
            this.status = (String)Preconditions.checkNotNull((Object)status);
            return this;
        }

        public PluginVersionBuilder license(LicenseType license) {
            this.license = (LicenseType)Preconditions.checkNotNull((Object)license);
            return this;
        }

        public PluginVersionBuilder version(String version) {
            this.version = (String)Preconditions.checkNotNull((Object)version);
            return this;
        }

        public PluginVersionBuilder deployable(boolean deployable) {
            this.deployable = deployable;
            return this;
        }

        public PluginVersionBuilder supportType(String supportType) {
            this.supportType = (String)Preconditions.checkNotNull((Object)supportType);
            return this;
        }

        public PluginVersionBuilder pluginSystemVersion(String pluginSystemVersion) {
            this.pluginSystemVersion = (String)Preconditions.checkNotNull((Object)pluginSystemVersion);
            return this;
        }

        public PluginVersionBuilder releaseNotes(Option<String> releaseNotes) {
            this.releaseNotes = (Option)Preconditions.checkNotNull(releaseNotes);
            return this;
        }

        public PluginVersionBuilder summary(Option<String> summary) {
            this.summary = (Option)Preconditions.checkNotNull(summary);
            return this;
        }

        public PluginVersionBuilder compatibleApplications(Iterable<ApplicationSummary> apps) {
            this.compatibleApplications = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(apps)));
            return this;
        }

        public PluginVersionBuilder compatibilities(Iterable<VersionCompatibility> compatibilities) {
            this.compatibilities = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(compatibilities)));
            return this;
        }

        public PluginVersionBuilder marketplaceType(MarketplaceType marketplaceType) {
            this.marketplaceType = (MarketplaceType)((Object)Preconditions.checkNotNull((Object)((Object)marketplaceType)));
            return this;
        }

        public PluginVersionBuilder marketplaceTypeTooltip(String marketplaceTypeTooltip) {
            this.marketplaceTypeTooltip = (String)Preconditions.checkNotNull((Object)marketplaceTypeTooltip);
            return this;
        }

        public PluginVersionBuilder screenshots(Iterable<Screenshot> screenshots) {
            this.screenshots = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(screenshots)));
            return this;
        }

        public PluginVersionBuilder youtubeId(Option<String> youtubeId) {
            this.youtubeId = (Option)Preconditions.checkNotNull(youtubeId);
            return this;
        }

        public PluginVersionBuilder binaryUri(Option<URI> uri) {
            if (!uri.isDefined()) {
                this.links.remove("binary");
            }
            for (URI u : uri) {
                this.links.put("binary", u);
            }
            return this;
        }
    }

    public static class PluginSummaryBuilder
    extends BuilderWithLinks<PluginSummaryBuilder> {
        private String name = DEFAULT_STRING;
        private String pluginKey = DEFAULT_STRING;
        private Option<String> summary = Option.none();
        private long downloadCount = DEFAULT_LONG;
        private Option<Modification> lastModified = Option.none();
        private Option<Date> lastReleasedDate = Option.none();
        private Option<Vendor> vendor = Option.none();
        private Icons icons = ModelBuilders.icons().build();
        private ReviewSummary reviewSummary = ModelBuilders.reviewSummary().build();
        private Collection<PluginCategory> categories = ImmutableList.of();
        private PluginVersion version = ModelBuilders.pluginVersion().build();
        private Collection<ApplicationSummary> compatibleApplications = ImmutableList.of();
        private Option<Pricing> pricing = Option.none();

        public PluginSummaryBuilder() {
            this.links.put("alternate", DEFAULT_URI);
        }

        public PluginSummary build() {
            return new PluginSummary(this.links.build(), this.name, this.pluginKey, (Vendor)this.vendor.getOrElse((Object)null), this.version, this.icons, ModelBuilders.nullableString((Option<String>)this.summary), this.reviewSummary, this.categories, this.downloadCount, (Modification)this.lastModified.getOrElse((Object)null), (Date)this.lastReleasedDate.getOrElse((Object)null), this.compatibleApplications, (Pricing)this.pricing.getOrElse((Object)null));
        }

        public PluginSummaryBuilder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        public PluginSummaryBuilder pluginKey(String pluginKey) {
            this.pluginKey = (String)Preconditions.checkNotNull((Object)pluginKey);
            return this;
        }

        public PluginSummaryBuilder summary(Option<String> summary) {
            this.summary = (Option)Preconditions.checkNotNull(summary);
            return this;
        }

        public PluginSummaryBuilder downloadCount(long downloadCount) {
            this.downloadCount = downloadCount;
            return this;
        }

        public PluginSummaryBuilder lastModified(Option<Modification> lastModified) {
            this.lastModified = (Option)Preconditions.checkNotNull(lastModified);
            return this;
        }

        public PluginSummaryBuilder lastReleasedDate(Option<Date> lastReleasedDate) {
            this.lastReleasedDate = (Option)Preconditions.checkNotNull(lastReleasedDate);
            return this;
        }

        public PluginSummaryBuilder vendor(Option<Vendor> vendor) {
            this.vendor = (Option)Preconditions.checkNotNull(vendor);
            return this;
        }

        public PluginSummaryBuilder icons(Icons icons) {
            this.icons = (Icons)Preconditions.checkNotNull((Object)icons);
            return this;
        }

        public PluginSummaryBuilder reviewSummary(ReviewSummary reviewSummary) {
            this.reviewSummary = (ReviewSummary)Preconditions.checkNotNull((Object)reviewSummary);
            return this;
        }

        public PluginSummaryBuilder categories(Iterable<PluginCategory> categories) {
            this.categories = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(categories)));
            return this;
        }

        public PluginSummaryBuilder version(PluginVersion version) {
            this.version = (PluginVersion)Preconditions.checkNotNull((Object)version);
            return this;
        }

        public PluginSummaryBuilder compatibleApplications(Iterable<ApplicationSummary> apps) {
            this.compatibleApplications = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(apps)));
            return this;
        }

        public PluginSummaryBuilder pricing(Option<Pricing> pricing) {
            this.pricing = (Option)Preconditions.checkNotNull(pricing);
            return this;
        }
    }

    public static class PluginMediaBuilder {
        private Icons icons = ModelBuilders.icons().build();
        private Option<Banner> banner = Option.none();
        private Option<String> youtubeId = Option.none();
        private ImmutableList<Screenshot> screenshots = ImmutableList.of();

        public PluginMedia build() {
            return new PluginMedia(this.icons, (Banner)this.banner.getOrElse((Object)null), ModelBuilders.nullableString((Option<String>)this.youtubeId), (Collection<Screenshot>)this.screenshots);
        }

        public PluginMediaBuilder icons(Icons icons) {
            this.icons = (Icons)Preconditions.checkNotNull((Object)icons);
            return this;
        }

        public PluginMediaBuilder banner(Option<Banner> banner) {
            this.banner = (Option)Preconditions.checkNotNull(banner);
            return this;
        }

        public PluginMediaBuilder youtubeId(Option<String> youtubeId) {
            this.youtubeId = (Option)Preconditions.checkNotNull(youtubeId);
            return this;
        }

        public PluginMediaBuilder screenshots(Iterable<Screenshot> screenshots) {
            this.screenshots = ImmutableList.copyOf(screenshots);
            return this;
        }
    }

    public static class PluginCategoryBuilder
    extends BuilderWithLinks<PluginCategoryBuilder> {
        private String name = DEFAULT_STRING;

        public PluginCategoryBuilder() {
            this.links.put("alternate", DEFAULT_URI);
        }

        public PluginCategory build() {
            return new PluginCategory(this.links.build(), this.name);
        }

        public PluginCategoryBuilder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }
    }

    public static class PluginBuilder
    extends BuilderWithLinks<PluginBuilder> {
        private Date creationDate = DEFAULT_DATE;
        private String name = DEFAULT_STRING;
        private String pluginKey = DEFAULT_STRING;
        private Option<String> description = Option.none();
        private Option<String> summary = Option.none();
        private boolean deployable = true;
        private long downloadCount = DEFAULT_LONG;
        private Option<Modification> lastModified = Option.none();
        private Option<Vendor> vendor = Option.none();
        private PluginMedia media = ModelBuilders.pluginMedia().build();
        private ReviewSummary reviewSummary = ModelBuilders.reviewSummary().build();
        private Reviews reviews = ModelBuilders.reviews().build();
        private Collection<PluginCategory> categories = ImmutableList.of();
        private PluginVersion version = ModelBuilders.pluginVersion().build();
        private Collection<PluginVersion> versions = ImmutableList.of();
        private int versionsCount = DEFAULT_INT;
        private boolean isOldVersion = false;
        private Collection<ApplicationSummary> compatibleApplications = ImmutableList.of();
        private Option<Pricing> pricing = Option.none();

        public PluginBuilder() {
            this.links.put("alternate", DEFAULT_URI);
        }

        public Plugin build() {
            return new Plugin(this.links.build(), this.creationDate, this.name, this.pluginKey, ModelBuilders.nullableString((Option<String>)this.description), ModelBuilders.nullableString((Option<String>)this.summary), this.deployable, this.downloadCount, (Modification)this.lastModified.getOrElse((Object)null), (Vendor)this.vendor.getOrElse((Object)null), this.media, this.reviewSummary, this.reviews, this.categories, this.version, new Plugin.PluginVersions(this.versions, this.versionsCount), this.isOldVersion, this.compatibleApplications, (Pricing)this.pricing.getOrElse((Object)null));
        }

        public PluginBuilder creationDate(Date date) {
            this.creationDate = (Date)Preconditions.checkNotNull((Object)date);
            return this;
        }

        public PluginBuilder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        public PluginBuilder pluginKey(String pluginKey) {
            this.pluginKey = (String)Preconditions.checkNotNull((Object)pluginKey);
            return this;
        }

        public PluginBuilder description(Option<String> description) {
            this.description = (Option)Preconditions.checkNotNull(description);
            return this;
        }

        public PluginBuilder summary(Option<String> summary) {
            this.summary = (Option)Preconditions.checkNotNull(summary);
            return this;
        }

        public PluginBuilder deployable(boolean deployable) {
            this.deployable = deployable;
            return this;
        }

        public PluginBuilder downloadCount(long downloadCount) {
            this.downloadCount = downloadCount;
            return this;
        }

        public PluginBuilder lastModified(Option<Modification> lastModified) {
            this.lastModified = (Option)Preconditions.checkNotNull(lastModified);
            return this;
        }

        public PluginBuilder vendor(Option<Vendor> vendor) {
            this.vendor = (Option)Preconditions.checkNotNull(vendor);
            return this;
        }

        public PluginBuilder media(PluginMedia pluginMedia) {
            this.media = (PluginMedia)Preconditions.checkNotNull((Object)pluginMedia);
            return this;
        }

        public PluginBuilder reviewSummary(ReviewSummary reviewSummary) {
            this.reviewSummary = (ReviewSummary)Preconditions.checkNotNull((Object)reviewSummary);
            return this;
        }

        public PluginBuilder reviews(Reviews reviews) {
            this.reviews = (Reviews)Preconditions.checkNotNull((Object)reviews);
            return this;
        }

        public PluginBuilder categories(Iterable<PluginCategory> categories) {
            this.categories = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(categories)));
            return this;
        }

        public PluginBuilder version(PluginVersion version) {
            this.version = (PluginVersion)Preconditions.checkNotNull((Object)version);
            return this;
        }

        public PluginBuilder versions(Iterable<PluginVersion> versions) {
            this.versions = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(versions)));
            return this;
        }

        public PluginBuilder versionsCount(int count) {
            this.versionsCount = count;
            return this;
        }

        public PluginBuilder oldVersion(boolean isOldVersion) {
            this.isOldVersion = isOldVersion;
            return this;
        }

        public PluginBuilder compatibleApplications(Iterable<ApplicationSummary> apps) {
            this.compatibleApplications = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(apps)));
            return this;
        }

        public PluginBuilder pricing(Option<Pricing> pricing) {
            this.pricing = (Option)Preconditions.checkNotNull(pricing);
            return this;
        }
    }

    public static class ModificationBuilder {
        private String by = DEFAULT_STRING;
        private Date date = DEFAULT_DATE;

        public Modification build() {
            return new Modification(this.by, this.date);
        }

        public ModificationBuilder by(String by) {
            this.by = (String)Preconditions.checkNotNull((Object)by);
            return this;
        }

        public ModificationBuilder date(Date date) {
            this.date = (Date)Preconditions.checkNotNull((Object)date);
            return this;
        }
    }

    public static class LinksBuilder {
        private Map<Pair<String, Option<String>>, URI> links = new HashMap<Pair<String, Option<String>>, URI>();

        public Links build() {
            ImmutableList.Builder items = ImmutableList.builder();
            for (Map.Entry<Pair<String, Option<String>>, URI> entry : this.links.entrySet()) {
                items.add((Object)new Links.Link((String)entry.getKey().first(), (String)((Option)entry.getKey().second()).getOrElse((Object)null), entry.getValue()));
            }
            return new Links((Collection<Links.Link>)items.build());
        }

        public LinksBuilder put(String rel, URI uri) {
            return this.put(rel, (Option<String>)Option.none(String.class), uri);
        }

        public LinksBuilder put(String rel, Option<String> type, URI uri) {
            this.links.put((Pair<String, Option<String>>)Pair.pair((Object)Preconditions.checkNotNull((Object)rel), type), (URI)Preconditions.checkNotNull((Object)uri));
            return this;
        }

        public LinksBuilder put(Links links) {
            for (Links.Link item : links.getItems()) {
                this.put(item.getRel(), item.getType(), item.getHref());
            }
            return this;
        }

        public LinksBuilder put(Map<String, URI> links) {
            for (Map.Entry<String, URI> item : links.entrySet()) {
                this.put(item.getKey(), item.getValue());
            }
            return this;
        }

        public LinksBuilder remove(String rel) {
            this.links.remove(Pair.pair((Object)Preconditions.checkNotNull((Object)rel), (Object)Option.none(String.class)));
            return this;
        }

        public LinksBuilder remove(String rel, String type) {
            this.links.remove(Pair.pair((Object)Preconditions.checkNotNull((Object)rel), (Object)Option.some((Object)type)));
            return this;
        }

        public LinksBuilder removeAll() {
            this.links.clear();
            return this;
        }
    }

    public static class LicenseTypeBuilder
    extends BuilderWithLinks<LicenseTypeBuilder> {
        private String id = DEFAULT_STRING;
        private String name = DEFAULT_STRING;

        public LicenseTypeBuilder() {
            this.links.put("alternate", DEFAULT_URI);
        }

        public LicenseType build() {
            return new LicenseType(this.links.build(), this.id, this.name);
        }

        public LicenseTypeBuilder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id);
            return this;
        }

        public LicenseTypeBuilder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }
    }

    public static final class ImageBuilder
    extends BuilderWithLinks<ImageBuilder> {
        private int width = DEFAULT_INT;
        private int height = DEFAULT_INT;
        private Option<String> altText = Option.none();

        public ImageBuilder() {
            this.links.put("binary", DEFAULT_URI);
        }

        public Image build() {
            return new Image(this.links.build(), this.width, this.height, ModelBuilders.nullableString((Option<String>)this.altText));
        }

        public ImageBuilder width(int width) {
            this.width = width;
            return this;
        }

        public ImageBuilder height(int height) {
            this.height = height;
            return this;
        }

        public ImageBuilder altText(Option<String> altText) {
            this.altText = (Option)Preconditions.checkNotNull(altText);
            return this;
        }
    }

    public static final class IconsBuilder {
        private Option<Image> defaultIcon = Option.none();
        private Option<Image> tinyIcon = Option.none();

        public Icons build() {
            return new Icons((Image)this.defaultIcon.getOrElse((Object)null), (Image)this.tinyIcon.getOrElse((Object)null));
        }

        public IconsBuilder defaultIcon(Option<Image> defaultIcon) {
            this.defaultIcon = (Option)Preconditions.checkNotNull(defaultIcon);
            return this;
        }

        public IconsBuilder tinyIcon(Option<Image> tinyIcon) {
            this.tinyIcon = (Option)Preconditions.checkNotNull(tinyIcon);
            return this;
        }
    }

    public static final class BannerBuilder {
        private String pluginKey = DEFAULT_STRING;
        private Image image = ModelBuilders.image().build();
        private Option<Image> carouselImage = Option.none();

        public Banner build() {
            return new Banner(this.pluginKey, this.image, (Image)this.carouselImage.getOrElse((Object)null));
        }

        public BannerBuilder pluginKey(String pluginKey) {
            this.pluginKey = (String)Preconditions.checkNotNull((Object)pluginKey);
            return this;
        }

        public BannerBuilder image(Image image) {
            this.image = (Image)Preconditions.checkNotNull((Object)image);
            return this;
        }

        public BannerBuilder carouselImage(Option<Image> carouselImage) {
            this.carouselImage = (Option)Preconditions.checkNotNull(carouselImage);
            return this;
        }
    }

    public static final class ApplicationVersionBuilder
    extends BuilderWithLinks<ApplicationVersionBuilder> {
        private long buildNumber = DEFAULT_LONG;
        private String version = DEFAULT_STRING;
        private Date releaseDate = DEFAULT_DATE;
        private boolean published = false;

        public ApplicationVersion build() {
            String status = this.published ? "Published" : "Draft";
            return new ApplicationVersion(this.links.build(), this.buildNumber, this.version, this.releaseDate, new KeyValuePair(status, status));
        }

        public ApplicationVersionBuilder buildNumber(long buildNumber) {
            this.buildNumber = buildNumber;
            return this;
        }

        public ApplicationVersionBuilder version(String version) {
            this.version = (String)Preconditions.checkNotNull((Object)version);
            return this;
        }

        public ApplicationVersionBuilder releaseDate(Date releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public ApplicationVersionBuilder published(boolean published) {
            this.published = published;
            return this;
        }
    }

    public static final class ApplicationSummaryBuilder
    extends BuilderWithLinks<ApplicationSummaryBuilder> {
        private ApplicationKey key = ApplicationKey.valueOf(DEFAULT_STRING);
        private String name = DEFAULT_STRING;
        private int order = DEFAULT_INT;
        private int pluginCount = DEFAULT_INT;

        public ApplicationSummary build() {
            return new ApplicationSummary(this.links.build(), this.key.getKey(), this.name, this.order, this.pluginCount);
        }

        public ApplicationSummaryBuilder key(ApplicationKey key) {
            this.key = (ApplicationKey)Preconditions.checkNotNull((Object)key);
            return this;
        }

        public ApplicationSummaryBuilder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        public ApplicationSummaryBuilder order(int order) {
            this.order = order;
            return this;
        }

        public ApplicationSummaryBuilder pluginCount(int pluginCount) {
            this.pluginCount = pluginCount;
            return this;
        }
    }

    public static final class ApplicationBuilder
    extends BuilderWithLinks<ApplicationBuilder> {
        private ApplicationKey key = ApplicationKey.valueOf(DEFAULT_STRING);
        private String name = DEFAULT_STRING;
        private int order = DEFAULT_INT;
        private int pluginCount = DEFAULT_INT;
        private Collection<ApplicationVersion> versions = ImmutableList.of();
        private Collection<String> categories = ImmutableList.of();

        public Application build() {
            return new Application(this.links.build(), this.key.getKey(), this.name, this.order, this.pluginCount, this.versions, this.categories);
        }

        public ApplicationBuilder key(ApplicationKey key) {
            this.key = (ApplicationKey)Preconditions.checkNotNull((Object)key);
            return this;
        }

        public ApplicationBuilder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        public ApplicationBuilder order(int order) {
            this.order = order;
            return this;
        }

        public ApplicationBuilder pluginCount(int pluginCount) {
            this.pluginCount = pluginCount;
            return this;
        }

        public ApplicationBuilder versions(Iterable<ApplicationVersion> versions) {
            this.versions = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(versions)));
            return this;
        }

        public ApplicationBuilder categories(Iterable<String> categories) {
            this.categories = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(categories)));
            return this;
        }
    }

    public static abstract class BuilderWithLinks<T extends BuilderWithLinks<T>> {
        protected LinksBuilder links = new LinksBuilder();

        public T links(Links links) {
            this.links.removeAll();
            this.links.put(links);
            return (T)this;
        }

        public T addLink(String rel, URI uri) {
            this.links.put(rel, uri);
            return (T)this;
        }

        public T addLink(String rel, String type, URI uri) {
            this.links.put(rel, (Option<String>)Option.some((Object)type), uri);
            return (T)this;
        }
    }
}

