/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.model;

import com.atlassian.marketplace.client.util.ModelUtil;
import com.atlassian.upm.api.util.Option;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collection;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonValue;

public final class Links {
    public static final String REST_TYPE = "application/json";
    public static final String WEB_TYPE = "text/html";
    private final Collection<Link> items;

    @JsonCreator
    Links(Collection<Link> items) {
        this.items = ImmutableList.copyOf(items);
    }

    @JsonValue
    public Collection<Link> getItems() {
        return this.items;
    }

    public Option<URI> get(String rel) {
        for (Link link : this.items) {
            if (!rel.equalsIgnoreCase(link.getRel())) continue;
            return Option.some((Object)link.getHref());
        }
        return Option.none();
    }

    public Option<URI> get(String rel, String contentType) {
        for (Link link : this.items) {
            if (!rel.equalsIgnoreCase(link.getRel()) || !contentType.equalsIgnoreCase((String)link.getType().getOrElse((Object)""))) continue;
            return Option.some((Object)link.getHref());
        }
        return Option.none();
    }

    public Option<String> getContentType(String rel) {
        for (Link link : this.items) {
            if (!rel.equalsIgnoreCase(link.getRel())) continue;
            return link.getType();
        }
        return Option.none();
    }

    public static final class Link {
        @JsonProperty
        private final String rel;
        @JsonProperty
        private final String type;
        @JsonProperty
        private final URI href;

        @JsonCreator
        Link(@JsonProperty(value="rel") String rel, @JsonProperty(value="type") String type, @JsonProperty(value="href") URI href) {
            this.rel = ModelUtil.requireProperty(rel, "rel");
            this.type = type;
            this.href = ModelUtil.requireProperty(href, "href");
        }

        public String getRel() {
            return this.rel;
        }

        @JsonIgnore
        public Option<String> getType() {
            return Option.option((Object)this.type);
        }

        public URI getHref() {
            return this.href;
        }
    }
}

