/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.model;

import com.atlassian.marketplace.client.model.Links;
import com.atlassian.marketplace.client.util.ModelUtil;
import com.atlassian.upm.api.util.Option;
import java.net.URI;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public final class Image {
    @JsonProperty
    private final Links links;
    private final URI binaryUri;
    @JsonProperty
    private final int width;
    @JsonProperty
    private final int height;
    @JsonProperty
    private final String altText;

    @JsonCreator
    Image(@JsonProperty(value="links") Links links, @JsonProperty(value="width") Integer width, @JsonProperty(value="height") Integer height, @JsonProperty(value="altText") String altText) {
        this.links = ModelUtil.requireProperty(links, "links");
        this.binaryUri = ModelUtil.requireLink(links, "binary");
        this.width = ModelUtil.requireProperty(width, "width");
        this.height = ModelUtil.requireProperty(height, "height");
        this.altText = altText;
    }

    public Links getLinks() {
        return this.links;
    }

    @JsonIgnore
    public URI getImageUri() {
        return this.binaryUri;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @JsonIgnore
    public Option<String> getImageContentType() {
        return this.links.getContentType("binary");
    }

    @JsonIgnore
    public Option<String> getAltText() {
        return Option.option((Object)this.altText);
    }
}

