/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.impl;

import com.atlassian.marketplace.client.MpacException;
import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.api.BannerQuery;
import com.atlassian.marketplace.client.api.Page;
import com.atlassian.marketplace.client.api.PageReference;
import com.atlassian.marketplace.client.api.PluginDetailQuery;
import com.atlassian.marketplace.client.api.PluginQuery;
import com.atlassian.marketplace.client.api.Plugins;
import com.atlassian.marketplace.client.api.PricingQuery;
import com.atlassian.marketplace.client.impl.DefaultMarketplaceClient;
import com.atlassian.marketplace.client.impl.PageImpl;
import com.atlassian.marketplace.client.impl.representations.PluginBannersRepresentation;
import com.atlassian.marketplace.client.impl.representations.PluginsRepresentation;
import com.atlassian.marketplace.client.impl.representations.RootRepresentation;
import com.atlassian.marketplace.client.model.Banner;
import com.atlassian.marketplace.client.model.LicenseType;
import com.atlassian.marketplace.client.model.Links;
import com.atlassian.marketplace.client.model.Plugin;
import com.atlassian.marketplace.client.model.PluginSummary;
import com.atlassian.marketplace.client.model.PluginVersion;
import com.atlassian.marketplace.client.model.VersionCompatibility;
import com.atlassian.marketplace.client.util.UriBuilder;
import com.atlassian.upm.api.util.Option;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.codehaus.jackson.annotate.JsonProperty;

final class PluginsImpl
implements Plugins {
    static final int DEFAULT_LIMIT = 10;
    private final DefaultMarketplaceClient client;
    private final RootRepresentation root;

    PluginsImpl(DefaultMarketplaceClient client, RootRepresentation root) {
        this.client = client;
        this.root = root;
    }

    @Override
    public Page<PluginSummary> find(PluginQuery query) throws MpacException {
        UriBuilder uri = this.getQueryBaseUri(query);
        this.addAppParams(uri, query.getApplication(), query.getAppBuildNumber());
        for (String c : query.getCategories()) {
            uri.queryParam("category", c);
        }
        for (PluginQuery.Cost cost : query.getCost()) {
            uri.queryParam("cost", cost.getKey());
        }
        for (PricingQuery pricing : query.getIncludePricing()) {
            uri.queryParam("pricing", "true");
            for (String licenseType : pricing.getLicenseType()) {
                uri.queryParam("licenseType", licenseType);
            }
        }
        this.addOffsetLimitParams(uri, query.getOffset(), query.getLimit());
        return this.getMorePlugins(new PageReference<PluginSummary>(uri.build(), query.getOffset(), query.getLimit()));
    }

    @Override
    public Page<PluginSummary> getMorePlugins(PageReference<PluginSummary> page) throws MpacException {
        PluginsRepresentation pluginsRep = this.client.getEntity(this.client.resolveLink(page.getUri()), PluginsRepresentation.class);
        return new PageImpl<PluginSummary>(page, pluginsRep.getLinks(), pluginsRep.getPlugins(), pluginsRep.getCount());
    }

    @Override
    public Option<Plugin> get(PluginDetailQuery query) throws MpacException {
        UriBuilder uri = this.getDetailQueryBaseUri(query);
        for (ApplicationKey appKey : query.getApplication()) {
            uri.queryParam("application", appKey.getKey());
            for (Long appBuild : query.getAppBuildNumber()) {
                uri.queryParam("buildNumber", appBuild);
            }
        }
        for (PricingQuery pricing : query.getIncludePricing()) {
            uri.queryParam("pricing", "true");
            for (String licenseType : pricing.getLicenseType()) {
                uri.queryParam("licenseType", licenseType);
            }
        }
        for (Integer limitVersions : query.getLimitVersions()) {
            uri.queryParam("limit-versions", limitVersions);
        }
        for (Integer limitReviews : query.getLimitReviews()) {
            uri.queryParam("limit-reviews", limitReviews);
        }
        return this.client.getOptionalEntity(uri.build(), Plugin.class);
    }

    @Override
    public Page<Banner> findBanners(BannerQuery query) throws MpacException {
        UriBuilder uri = this.getPluginsLink("banners");
        this.addAppParams(uri, query.getApplication(), query.getAppBuildNumber());
        for (String label : query.getLabel()) {
            uri.queryParam("marketingLabel", label);
        }
        this.addOffsetLimitParams(uri, query.getOffset(), query.getLimit());
        return this.getMoreBanners(new PageReference<Banner>(uri.build(), query.getOffset(), query.getLimit()));
    }

    @Override
    public Page<Banner> getMoreBanners(PageReference<Banner> page) throws MpacException {
        PluginBannersRepresentation bannersRep = this.client.getEntity(this.client.resolveLink(page.getUri()), PluginBannersRepresentation.class);
        return new PageImpl<Banner>(page, bannersRep.getLinks(), bannersRep.getBanners(), bannersRep.getCount());
    }

    @Override
    public void putVersion(String pluginKey, PluginVersion version) throws MpacException {
        this.client.putEntity(this.getVersionUri(pluginKey, version.getBuildNumber()).build(), new PluginVersionPutData(version));
    }

    private UriBuilder getQueryBaseUri(PluginQuery query) throws MpacException {
        Iterator i$ = query.getSearchText().iterator();
        if (i$.hasNext()) {
            String searchText = (String)i$.next();
            return this.pluginsBaseUri().path("search").queryParam("q", searchText);
        }
        i$ = query.getView().iterator();
        if (i$.hasNext()) {
            PluginQuery.View view = (PluginQuery.View)((Object)i$.next());
            return this.getPluginsLink(view.getKey());
        }
        return this.pluginsBaseUri();
    }

    private UriBuilder getDetailQueryBaseUri(PluginDetailQuery query) throws MpacException {
        Iterator i$ = query.getVersion().iterator();
        if (i$.hasNext()) {
            PluginDetailQuery.Version version = (PluginDetailQuery.Version)i$.next();
            UriBuilder ret = this.pluginsBaseUri().path(this.client.urlEncode(query.getPluginKey())).path("version").path(this.client.urlEncode(version.getVersion()));
            return version.isGreaterThan() ? ret.path("update") : ret;
        }
        return this.pluginsBaseUri().path(query.getPluginKey());
    }

    private UriBuilder getVersionUri(String pluginKey, long buildNumber) throws MpacException {
        return this.pluginsBaseUri().path(this.client.urlEncode(pluginKey)).path("build-number").path(String.valueOf(buildNumber));
    }

    private void addAppParams(UriBuilder uri, Option<ApplicationKey> appKey, Option<Long> appBuild) {
        for (ApplicationKey a : appKey) {
            uri.queryParam("application", a.getKey());
            for (Long b : appBuild) {
                uri.queryParam("buildNumber", b);
            }
        }
    }

    private void addOffsetLimitParams(UriBuilder uri, int offset, Option<Integer> limit) {
        if (offset > 0) {
            uri.queryParam("offset", offset);
        }
        for (Integer l : limit) {
            uri.queryParam("limit", l);
        }
    }

    private UriBuilder pluginsBaseUri() throws MpacException {
        return UriBuilder.fromUri(this.client.requireLinkUri(this.root.getLinks(), "plugins", this.root.getClass()));
    }

    private PluginsRepresentation pluginsBaseResource() throws MpacException {
        return this.client.getEntity(this.pluginsBaseUri().queryParam("limit", 0).build(), PluginsRepresentation.class);
    }

    private UriBuilder getPluginsLink(String rel) throws MpacException {
        PluginsRepresentation pluginsBase = this.pluginsBaseResource();
        return UriBuilder.fromUri(this.client.requireLinkUri(pluginsBase.getLinks(), rel, PluginsRepresentation.class));
    }

    static final class PluginVersionPutData {
        @JsonProperty
        final Collection<CompatibilityPutData> compatibilities;
        @JsonProperty
        final boolean deployable;
        @JsonProperty
        final String focus;
        @JsonProperty
        final LicenseType license;
        @JsonProperty
        final Links links;
        @JsonProperty
        final String marketplaceType;
        @JsonProperty
        final String pluginSystemVersion;
        @JsonProperty
        final Date releaseDate;
        @JsonProperty
        final String releaseNotes;
        @JsonProperty
        final boolean stable;
        @JsonProperty
        final String status;
        @JsonProperty
        final String summary;
        @JsonProperty
        final String supportType;
        @JsonProperty
        final String version;
        @JsonProperty
        final String youtubeId;

        PluginVersionPutData(PluginVersion from) {
            this.compatibilities = ImmutableList.copyOf((Iterable)Iterables.transform(from.getCompatibilities(), this.toCompatibilityPutData()));
            this.deployable = from.isDeployable();
            this.focus = (String)from.getReleaseFocus().getOrElse((Object)null);
            this.license = from.getLicense();
            this.links = from.getLinks();
            this.marketplaceType = from.getMarketplaceType().getDisplayName();
            this.pluginSystemVersion = from.getPluginSystemVersion();
            this.supportType = from.getSupportType();
            this.releaseDate = from.getReleaseDate();
            this.releaseNotes = (String)from.getReleaseNotes().getOrElse((Object)null);
            this.stable = from.isStable();
            this.status = from.getStatus();
            this.summary = (String)from.getSummary().getOrElse((Object)null);
            this.version = from.getVersion();
            this.youtubeId = (String)from.getYoutubeId().getOrElse((Object)null);
        }

        private Function<VersionCompatibility, CompatibilityPutData> toCompatibilityPutData() {
            return new Function<VersionCompatibility, CompatibilityPutData>(){

                public CompatibilityPutData apply(VersionCompatibility from) {
                    return new CompatibilityPutData(from);
                }
            };
        }

        static final class CompatibilityPutData {
            @JsonProperty
            final String applicationName;
            @JsonProperty
            final long min;
            @JsonProperty
            final long max;

            CompatibilityPutData(VersionCompatibility from) {
                this.applicationName = from.getApplicationName();
                this.min = from.getMin().getBuildNumber();
                this.max = from.getMax().getBuildNumber();
            }
        }
    }
}

