package com.atlassian.marketplace.client.model;

import java.util.Collection;

import com.google.common.collect.ImmutableList;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireList;
import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;

/**
 * A collection of user reviews.
 */
public class Reviews
{
    @JsonProperty private final Links links;
    @JsonProperty private final Collection<Review> reviews;
    
    @JsonCreator
    Reviews(@JsonProperty("links") Links links,
            @JsonProperty("reviews") Collection<Review> reviews)
    {
        this.links = requireProperty(links, "links");
        this.reviews = requireList(reviews, "reviews");
    }

    public Links getLinks()
    {
        return links;
    }

    /**
     * The list of reviews.
     */
    @JsonIgnore
    public Iterable<Review> getReviews()
    {
        return ImmutableList.copyOf(reviews);
    }
}
