package com.atlassian.marketplace.client;

import com.atlassian.marketplace.client.api.Applications;
import com.atlassian.marketplace.client.api.Categories;
import com.atlassian.marketplace.client.api.Plugins;

/**
 * Client interface for the Atlassian Marketplace API.
 * <p>
 * Construct a concrete implementation of the client ({@link com.atlassian.marketplace.client.impl.DefaultMarketplaceClient})
 * and use that instance for all API requests.
 */
public interface MarketplaceClient
{
    /**
     * Checks whether the MPAC service is available, by attempting to get the root resource.
     * 
     * @return  true if the request was successful; false if it failed for any reason
     */
    public boolean isReachable();
    
    /**
     * Returns an API object that provides access to plugin information.
     */
    public Plugins plugins() throws MpacException;

    /**
     * Returns an API object that provides access to category information.
     */
    public Categories categories() throws MpacException;
    
    /**
     * Returns an API object that provides access to application information.
     */
    public Applications applications() throws MpacException;
}
