/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.upgrade;

import com.atlassian.upm.api.log.EntryType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class LegacyRepresentations {

    static class PluginRequestRepresentationV1 {
        @JsonProperty
        final Map<String, URI> links;
        @JsonProperty
        final String pluginKey;
        @JsonProperty
        final String pluginName;
        @JsonProperty
        final UserProfileRepresentationV1 user;
        @JsonProperty
        final Date timestamp;
        @JsonProperty
        final String message;

        @JsonCreator
        PluginRequestRepresentationV1(@JsonProperty(value="links") Map<String, URI> links, @JsonProperty(value="pluginKey") String pluginKey, @JsonProperty(value="pluginName") String pluginName, @JsonProperty(value="user") UserProfileRepresentationV1 user, @JsonProperty(value="timestamp") Date timestamp, @JsonProperty(value="message") String message) {
            this.links = ImmutableMap.copyOf(links);
            this.pluginKey = pluginKey;
            this.pluginName = pluginName;
            this.user = user;
            this.timestamp = timestamp;
            this.message = message;
        }

        static class UserProfileRepresentationV1 {
            @JsonProperty
            final String username;
            @JsonProperty
            final String displayName;
            @JsonProperty
            final URI userProfileUri;

            @JsonCreator
            UserProfileRepresentationV1(@JsonProperty(value="username") String username, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="userProfileUri") URI userProfileUri) {
                this.username = username;
                this.displayName = displayName;
                this.userProfileUri = userProfileUri;
            }
        }
    }

    static final class AuditLogRepresentationV1 {
        @JsonProperty
        final String username;
        @JsonProperty
        final Date date;
        @JsonProperty
        final String i18nKey;
        @JsonProperty
        final String[] params;
        @JsonProperty
        final EntryType entryType;

        @JsonCreator
        AuditLogRepresentationV1(@JsonProperty(value="username") String username, @JsonProperty(value="date") Date date, @JsonProperty(value="i18nKey") String i18nKey, @JsonProperty(value="entryType") EntryType entryType, String ... params) {
            this.username = (String)Preconditions.checkNotNull((Object)username, (Object)"username");
            this.date = (Date)Preconditions.checkNotNull((Object)date, (Object)"date");
            this.i18nKey = (String)Preconditions.checkNotNull((Object)i18nKey, (Object)"i18nKey");
            this.params = (String[])Preconditions.checkNotNull((Object)params, (Object)"params");
            this.entryType = entryType == null ? EntryType.valueOfI18n(i18nKey) : entryType;
        }
    }
}

