/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.resources;

import com.atlassian.marketplace.client.MpacException;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.upm.ProductUpdatePluginCompatibility;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginMetadataAccessor;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.Plugins;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.pac.PacClient;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/product-updates/{build-number}/compatibility")
public class ProductUpdatePluginCompatibilityResource {
    private final UpmRepresentationFactory representationFactory;
    private final LocaleResolver localeResolver;
    private final PacClient client;
    private final PermissionEnforcer permissionEnforcer;
    private final PluginMetadataAccessor metadata;
    private final PluginRetriever pluginRetriever;
    private final UpmAppManager appManager;

    public ProductUpdatePluginCompatibilityResource(UpmRepresentationFactory factory, LocaleResolver localeResolver, PacClient client, PermissionEnforcer permissionEnforcer, PluginMetadataAccessor metadata, PluginRetriever pluginRetriever, UpmAppManager appManager) {
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
        this.localeResolver = (LocaleResolver)Preconditions.checkNotNull((Object)localeResolver, (Object)"localeResolver");
        this.representationFactory = (UpmRepresentationFactory)Preconditions.checkNotNull((Object)factory, (Object)"representationFactory");
        this.client = (PacClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.metadata = (PluginMetadataAccessor)Preconditions.checkNotNull((Object)metadata, (Object)"metadata");
        this.pluginRetriever = (PluginRetriever)Preconditions.checkNotNull((Object)pluginRetriever, (Object)"pluginRetriever");
        this.appManager = (UpmAppManager)Preconditions.checkNotNull((Object)appManager, (Object)"appManager");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins.compatibility+json"})
    public Response get(@PathParam(value="build-number") String buildNumber, @Context HttpServletRequest request) throws MpacException {
        this.permissionEnforcer.enforcePermission(Permission.GET_PRODUCT_UPDATE_COMPATIBILITY);
        int buildNumberInt = Integer.parseInt(buildNumber);
        Iterable<Plugin> allPlugins = this.pluginRetriever.getPlugins();
        Set<String> applicationPluginKeys = this.appManager.getApplicationRelatedPlugins(Iterables.transform(allPlugins, Plugins.toPlugPlugin)).keySet();
        Predicate isApplicationPlugin = Predicates.compose((Predicate)Predicates.in(applicationPluginKeys), Plugins.toPluginKey);
        Iterable filteredPlugins = Iterables.filter(allPlugins, (Predicate)Predicates.and(Plugins.userInstalled(this.metadata), (Predicate)Predicates.not((Predicate)isApplicationPlugin)));
        ProductUpdatePluginCompatibility pluginCompatibility = this.client.getProductUpdatePluginCompatibility(filteredPlugins, buildNumberInt);
        return Response.ok((Object)this.representationFactory.createProductUpdatePluginCompatibilityRepresentation(pluginCompatibility, buildNumberInt, this.localeResolver.getLocale(request))).build();
    }
}

