/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.pac;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.marketplace.client.MpacException;
import com.atlassian.marketplace.client.api.AddonQuery;
import com.atlassian.marketplace.client.api.AddonVersionSpecifier;
import com.atlassian.marketplace.client.api.AddonVersionsQuery;
import com.atlassian.marketplace.client.api.Addons;
import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.api.ApplicationVersionSpecifier;
import com.atlassian.marketplace.client.api.ApplicationVersionsQuery;
import com.atlassian.marketplace.client.api.HostingType;
import com.atlassian.marketplace.client.api.Page;
import com.atlassian.marketplace.client.api.PageReference;
import com.atlassian.marketplace.client.api.QueryBounds;
import com.atlassian.marketplace.client.model.Addon;
import com.atlassian.marketplace.client.model.AddonCategorySummary;
import com.atlassian.marketplace.client.model.AddonReference;
import com.atlassian.marketplace.client.model.AddonSummary;
import com.atlassian.marketplace.client.model.AddonVersion;
import com.atlassian.marketplace.client.model.ApplicationVersion;
import com.atlassian.marketplace.client.model.Links;
import com.atlassian.marketplace.client.model.VersionCompatibility;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.upm.ApplicationKeyUtils;
import com.atlassian.upm.Iterables;
import com.atlassian.upm.LazyReferences;
import com.atlassian.upm.MarketplacePlugins;
import com.atlassian.upm.ProductUpdatePluginCompatibility;
import com.atlassian.upm.SysPersisted;
import com.atlassian.upm.UpmFugueConverters;
import com.atlassian.upm.UpmHostApplicationInformation;
import com.atlassian.upm.UpmSettings;
import com.atlassian.upm.analytics.event.PluginUpdateCheckAnalyticsEvent;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.api.util.Options;
import com.atlassian.upm.api.util.Pair;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginMetadataAccessor;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.Plugins;
import com.atlassian.upm.core.analytics.AnalyticsLogger;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.core.pac.MarketplaceClientManager;
import com.atlassian.upm.core.pac.PlatformBuildNumberChangeEvent;
import com.atlassian.upm.license.internal.PluginLicenseRepository;
import com.atlassian.upm.pac.AvailableAddonWithVersion;
import com.atlassian.upm.pac.IncompatiblePluginData;
import com.atlassian.upm.pac.PacClient;
import com.atlassian.upm.pac.PluginVersionPair;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import io.atlassian.util.concurrent.AsyncCompleter;
import io.atlassian.util.concurrent.LazyReference;
import io.atlassian.util.concurrent.ResettableLazyReference;
import io.atlassian.util.concurrent.RuntimeTimeoutException;
import io.atlassian.util.concurrent.ThreadFactories;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public final class PacClientImpl
implements PacClient,
DisposableBean,
InitializingBean {
    private final Duration UPDATE_CHECK_TIMEOUT = Duration.standardSeconds((long)10L);
    private final Duration UPDATE_CHECK_MAX_TIMEOUT = Duration.standardSeconds((long)60L);
    private final Duration PLUGIN_DETAILS_TIMEOUT = Duration.standardSeconds((long)10L);
    private final ApplicationProperties applicationProperties;
    private final CacheFactory cacheFactory;
    private final EventPublisher eventPublisher;
    private final PluginRetriever pluginRetriever;
    private final PluginMetadataAccessor metadata;
    private final PluginVersionComparator pluginVersionComparator;
    private final SpiPluginComparator pluginComparator;
    private final CachedReference<Option<MpacApplication>> mpacAppRef;
    private final ResettableLazyReference<Boolean> reachable;
    private final ResettableLazyReference<Execution> async;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SysPersisted sysPersisted;
    private final MarketplaceClientManager mpacV2ClientFactory;
    private final UpmHostApplicationInformation hostApplicationInformation;
    private final AnalyticsLogger analytics;
    private final UpmAppManager appManager;
    private final Cache<Pair<String, String>, Option<IncompatiblePluginData.IncompatibilityType>> pluginIncompatibilityCache;
    private final PluginLicenseRepository pluginLicenseRepository;
    private Function<Plugin, Callable<Option<IncompatiblePluginData>>> toIncompatiblePluginCallables = new Function<Plugin, Callable<Option<IncompatiblePluginData>>>(){

        public Callable<Option<IncompatiblePluginData>> apply(Plugin plugin) {
            return () -> {
                Iterator iterator = ((Option)PacClientImpl.this.pluginIncompatibilityCache.get(Pair.pair(plugin.getKey(), plugin.getVersion()))).iterator();
                if (iterator.hasNext()) {
                    IncompatiblePluginData.IncompatibilityType incompatibility = (IncompatiblePluginData.IncompatibilityType)((Object)((Object)iterator.next()));
                    return Option.some(new IncompatiblePluginData(plugin, incompatibility));
                }
                return Option.none();
            };
        }
    };

    public PacClientImpl(ApplicationProperties applicationProperties, CacheFactory cacheFactory, EventPublisher eventPublisher, final MarketplaceClientManager mpacV2ClientFactory, AnalyticsLogger analytics, PluginRetriever pluginRetriever, PluginMetadataAccessor metadata, SysPersisted sysPersisted, final ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory, UpmHostApplicationInformation hostApplicationInformation, UpmAppManager appManager, PluginLicenseRepository pluginLicenseRepository) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.cacheFactory = (CacheFactory)Preconditions.checkNotNull((Object)cacheFactory, (Object)"cacheFactory");
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher, (Object)"eventPublisher");
        this.analytics = (AnalyticsLogger)Preconditions.checkNotNull((Object)analytics, (Object)"analytics");
        this.mpacV2ClientFactory = (MarketplaceClientManager)Preconditions.checkNotNull((Object)mpacV2ClientFactory, (Object)"mpacV2ClientFactory");
        this.pluginRetriever = (PluginRetriever)Preconditions.checkNotNull((Object)pluginRetriever, (Object)"pluginRetriever");
        this.metadata = (PluginMetadataAccessor)Preconditions.checkNotNull((Object)metadata, (Object)"metadata");
        this.pluginVersionComparator = new PluginVersionComparator();
        this.pluginComparator = new SpiPluginComparator();
        this.sysPersisted = (SysPersisted)Preconditions.checkNotNull((Object)sysPersisted, (Object)"sysPersisted");
        this.hostApplicationInformation = (UpmHostApplicationInformation)Preconditions.checkNotNull((Object)hostApplicationInformation, (Object)"hostApplicationInformation");
        this.appManager = (UpmAppManager)Preconditions.checkNotNull((Object)appManager, (Object)"appManager");
        this.pluginLicenseRepository = (PluginLicenseRepository)Preconditions.checkNotNull((Object)pluginLicenseRepository, (Object)"pluginLicenseRepository");
        this.reachable = new ResettableLazyReference<Boolean>(){

            protected Boolean create() {
                return mpacV2ClientFactory.getMarketplaceClient().isReachable();
            }
        };
        this.mpacAppRef = this.createMpacAppRef();
        this.async = new ResettableLazyReference<Execution>(){

            protected Execution create() {
                return new Execution((ThreadLocalDelegateExecutorFactory)Preconditions.checkNotNull((Object)threadLocalDelegateExecutorFactory, (Object)"threadLocalDelegateExecutorFactory"));
            }
        };
        CacheSettings settings = new CacheSettingsBuilder().expireAfterWrite(12L, TimeUnit.HOURS).local().build();
        this.pluginIncompatibilityCache = cacheFactory.getCache("pluginCompatibilityCache", keyAndVersion -> {
            Iterator<AddonVersion> iterator = this.getAvailablePluginVersion((String)keyAndVersion.first(), (String)keyAndVersion.second()).iterator();
            if (iterator.hasNext()) {
                AddonVersion v = iterator.next();
                return this.getIncompatibilityType(v, pluginRetriever.getPlugin((String)keyAndVersion.first()));
            }
            return Option.none();
        }, settings);
    }

    private CachedReference<Option<MpacApplication>> createMpacAppRef() {
        CacheSettings settings = new CacheSettingsBuilder().expireAfterWrite(4L, TimeUnit.HOURS).local().build();
        return this.cacheFactory.getCachedReference("app", () -> {
            if (this.sysPersisted.is(UpmSettings.PAC_DISABLED)) {
                return Option.none(MpacApplication.class);
            }
            return this.fetchMpacAppInfoForLocalBuild().orElse(this.fetchMpacAppInfoForLatest());
        }, settings);
    }

    private <A> Option<A> fetchMpacAppInfo(ApplicationVersionSpecifier q, Function<Option<ApplicationVersion>, Option<A>> found) {
        try {
            return (Option)found.apply(UpmFugueConverters.toUpmOption(this.mpacV2ClientFactory.getMarketplaceClient().applications().safeGetVersion(this.getMarketplaceApplicationKey(), q)));
        }
        catch (Exception e) {
            this.logger.warn("Error when querying application info from MPAC: " + e);
            return Option.none();
        }
    }

    private Option<MpacApplication> fetchMpacAppInfoForLatest() {
        if (this.hostApplicationInformation.isDevelopmentProductVersion()) {
            return this.fetchMpacAppInfo(ApplicationVersionSpecifier.latest(), this.toMpacInfo(true));
        }
        return Option.none();
    }

    private Option<MpacApplication> fetchMpacAppInfoForLocalBuild() {
        return this.fetchMpacAppInfo(ApplicationVersionSpecifier.buildNumber(this.hostApplicationInformation.getBuildNumber()), this.toMpacInfo(false));
    }

    private Function<Option<ApplicationVersion>, Option<MpacApplication>> toMpacInfo(boolean unknown) {
        return applicationVersion -> {
            Iterator iterator = applicationVersion.iterator();
            if (iterator.hasNext()) {
                ApplicationVersion av = (ApplicationVersion)iterator.next();
                return Option.some(new MpacApplication(unknown, Option.some(av.getBuildNumber())));
            }
            if (!this.hostApplicationInformation.isDevelopmentProductVersion()) {
                return Option.some(new MpacApplication(true, Option.none(Integer.class)));
            }
            return Option.none();
        };
    }

    @Override
    public Option<Boolean> isUnknownProductVersion() {
        return this.sysPersisted.is(UpmSettings.PAC_DISABLED) ? Option.none(Boolean.class) : this.unknownAppVersion();
    }

    private Option<MpacApplication> mpacApp() {
        return (Option)this.mpacAppRef.get();
    }

    private Option<Boolean> unknownAppVersion() {
        return this.mpacApp().map(a -> a.unknown);
    }

    private int getMpacAppBuildNumber() {
        return (Integer)this.mpacApp().flatMap(a -> a.buildNumber).getOrElse(this.hostApplicationInformation.getBuildNumber());
    }

    @Override
    public boolean isPacReachable() {
        if (this.sysPersisted.is(UpmSettings.PAC_DISABLED)) {
            return false;
        }
        return LazyReferences.safeGet(this.reachable);
    }

    @Override
    public Option<Links> getMarketplaceRootLinks() {
        if (this.sysPersisted.is(UpmSettings.PAC_DISABLED)) {
            return Option.none();
        }
        try {
            return Option.some(this.mpacV2ClientFactory.getMarketplaceClient().getRootLinks());
        }
        catch (MpacException e) {
            return Option.none();
        }
    }

    @EventListener
    public void onPlatformBuildNumberChangeEvent(PlatformBuildNumberChangeEvent event) {
        this.clearAllCachedMarketplaceState();
    }

    @Override
    public void forgetPacReachableState(boolean force) {
        this.reachable.reset();
        if (!this.sysPersisted.is(UpmSettings.PAC_DISABLED) && !this.mpacApp().isDefined() || force) {
            this.mpacAppRef.reset();
        }
    }

    @Override
    public void clearAllCachedMarketplaceState() {
        this.forgetPacReachableState(true);
        this.mpacAppRef.reset();
        this.pluginIncompatibilityCache.removeAll();
    }

    @Override
    public Page<AddonSummary> findPlugins(AddonQuery query) throws MpacException {
        if (!this.isPacReachable()) {
            return Page.empty();
        }
        return this.mpacV2ClientFactory.getMarketplaceClient().addons().find(this.addRequiredQueries(query));
    }

    private AddonQuery addRequiredQueries(AddonQuery query) {
        AddonQuery.Builder builder = ((AddonQuery.Builder)((AddonQuery.Builder)AddonQuery.builder(query).application((Optional)Optional.of(this.getMarketplaceApplicationKey()))).appBuildNumber((Optional)Optional.of(this.getMpacAppBuildNumber()))).hosting(Optional.of(HostingType.SERVER)).includeHidden(Optional.of(AddonQuery.IncludeHiddenType.VISIBLE_IN_APP)).bounds(query.getBounds().withLimit(Optional.of(10)));
        if (this.hostApplicationInformation.isHostDataCenterEnabled()) {
            builder.hosting((List)ImmutableList.of((Object)HostingType.DATA_CENTER, (Object)HostingType.SERVER));
        }
        return builder.build();
    }

    @Override
    public Option<AvailableAddonWithVersion> getAvailablePlugin(String key) throws MpacException {
        return this.getAvailablePluginInternal(key, true);
    }

    public Option<AddonVersion> getAvailablePluginVersion(String key, String version) {
        try {
            Optional<AddonVersion> maybeVersion;
            AddonVersionsQuery.Builder query = AddonVersionsQuery.builder();
            Addons addons = this.mpacV2ClientFactory.getMarketplaceClient().addons();
            if (this.hostApplicationInformation.isHostDataCenterEnabled() && (maybeVersion = addons.safeGetVersion(key, AddonVersionSpecifier.versionName(version), ((AddonVersionsQuery.Builder)query.hosting((Optional)Optional.of(HostingType.DATA_CENTER))).build())).isPresent()) {
                return Option.some(maybeVersion.get());
            }
            return UpmFugueConverters.toUpmOption(addons.safeGetVersion(key, AddonVersionSpecifier.versionName(version), ((AddonVersionsQuery.Builder)query.hosting((Optional)Optional.of(HostingType.SERVER))).build()));
        }
        catch (MpacException ex) {
            this.logger.debug("Error when retrieving plugin version from MPAC: " + key + "-" + version, (Throwable)ex);
            return Option.none();
        }
    }

    private Option<AvailableAddonWithVersion> getAvailablePluginInternal(String key, boolean withCompatibility) throws MpacException {
        if (!this.isPacReachable()) {
            return Option.none();
        }
        AddonQuery.Builder query = this.addonQueryDefaults().withVersion(true);
        if (!withCompatibility) {
            query.application(Optional.empty());
            query.appBuildNumber(Optional.empty());
        }
        return this.mpacV2ClientFactory.getMarketplaceClient().addons().safeGetByKey(key, query.build()).map(AvailableAddonWithVersion::fromAddon).orElseGet(Option::none);
    }

    @Override
    public Iterable<String> getCategories() throws MpacException {
        if (!this.isPacReachable()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Iterable)com.google.common.collect.Iterables.transform(this.mpacV2ClientFactory.getMarketplaceClient().addonCategories().findForApplication(this.getMarketplaceApplicationKey()), AddonCategorySummary::getName));
    }

    @Override
    public Page<AddonReference> findBanners(AddonQuery query) throws MpacException {
        if (!this.isPacReachable()) {
            return Page.empty();
        }
        return this.mpacV2ClientFactory.getMarketplaceClient().addons().findBanners(this.addRequiredQueries(query));
    }

    @Override
    public Iterable<AddonReference> getPluginRecommendations(String pluginKey, int maxItems) throws MpacException {
        return this.mpacV2ClientFactory.getMarketplaceClient().addons().findRecommendations(pluginKey, this.addonQueryDefaults().bounds(QueryBounds.limit(Optional.of(maxItems))).build());
    }

    private Execution getAsync() {
        return LazyReferences.safeGet(this.async);
    }

    @Override
    public Iterable<AvailableAddonWithVersion> getUpdates() {
        return this.getUpdates(true);
    }

    @Override
    public Iterable<AvailableAddonWithVersion> getUpdatesViaAutomatedJob() {
        return this.getUpdates(false);
    }

    @Override
    public Option<AvailableAddonWithVersion> getUpdate(Plugin installedPlugin) {
        if (!this.isPacReachable()) {
            return Option.none();
        }
        Iterable<AvailableAddonWithVersion> updates = this.getUpdates(false, true, (Iterable<Plugin>)ImmutableList.of((Object)installedPlugin));
        return Option.option(com.google.common.collect.Iterables.getFirst(updates, null));
    }

    private Iterable<AvailableAddonWithVersion> getUpdates(boolean userInitiated) {
        if (!this.isPacReachable()) {
            return ImmutableList.of();
        }
        return this.getUpdates(userInitiated, false, this.getUpdatablePlugins());
    }

    private Iterable<AvailableAddonWithVersion> getUpdates(boolean userInitiated, boolean skipAnalytics, Iterable<Plugin> updatablePlugins) {
        try {
            Addons addonsApi = this.mpacV2ClientFactory.getMarketplaceClient().addons();
            if (!skipAnalytics) {
                this.analytics.log(new PluginUpdateCheckAnalyticsEvent(updatablePlugins, userInitiated));
            }
            ImmutableList.Builder callables = ImmutableList.builder();
            updatablePlugins.forEach(p -> callables.add(() -> this.getAvailableUpdate(addonsApi, (Plugin)p)));
            int sizeUpdatablePlugins = com.google.common.collect.Iterables.size(updatablePlugins);
            Duration computedUpdateCheckTimeout = (Duration)Ordering.natural().min(Ordering.natural().max((Object)this.UPDATE_CHECK_TIMEOUT, (Object)Duration.standardSeconds((long)(sizeUpdatablePlugins / 2))), (Object)this.UPDATE_CHECK_MAX_TIMEOUT);
            if (userInitiated && computedUpdateCheckTimeout.isLongerThan((ReadableDuration)this.UPDATE_CHECK_TIMEOUT)) {
                this.logger.warn(String.format("The request to check for app updates may take longer than expected because %d apps are installed that could have updates. This may impact the performance of loading the Manage Apps page.", sizeUpdatablePlugins));
                this.logger.debug("Updatable apps {}", updatablePlugins);
            }
            return this.sortVersions((Iterable<AvailableAddonWithVersion>)ImmutableSet.copyOf(Options.catOptions(this.getAsync().invokeAll(callables.build(), computedUpdateCheckTimeout))));
        }
        catch (RuntimeTimeoutException ex) {
            this.logger.warn("Timed out while checking for app updates: " + (Object)((Object)ex));
            return ImmutableList.of();
        }
        catch (MpacException ex) {
            this.logger.debug("Error while accessing Marketplace: " + ex);
            return ImmutableList.of();
        }
    }

    private Option<AvailableAddonWithVersion> getAvailableUpdate(Addons addonsApi, Plugin plugin) {
        AddonQuery addonQuery = this.addonQueryDefaults().build();
        try {
            Iterator<AddonVersion> iterator = this.getUpdateVersion(addonsApi, plugin, plugin.getVersion(), AddonVersionsQuery.fromAddonQuery(addonQuery)).iterator();
            if (iterator.hasNext()) {
                AddonVersion v = iterator.next();
                return UpmFugueConverters.toUpmOption(addonsApi.safeGetByKey(plugin.getKey(), addonQuery).map(a -> new AvailableAddonWithVersion((Addon)a, v)));
            }
            return Option.none();
        }
        catch (MpacException ex) {
            this.logger.debug("Error when retrieving available update: " + plugin.getKey(), (Throwable)ex);
            return Option.none();
        }
    }

    private Option<AddonVersion> getUpdateVersion(Addons addonsApi, Plugin plugin, String version, AddonVersionsQuery.Builder queryDefaults) throws MpacException {
        if (this.hostApplicationInformation.isHostDataCenterEnabled()) {
            Option<AddonVersion> dataCenterVersion = UpmFugueConverters.toUpmOption(addonsApi.safeGetVersion(plugin.getKey(), AddonVersionSpecifier.latest(), ((AddonVersionsQuery.Builder)queryDefaults.afterVersion(Optional.of(version)).hosting((Optional)Optional.of(HostingType.DATA_CENTER))).build()));
            if (Plugins.isStatusDataCenterCompatibleAccordingToPluginDescriptor(plugin) || this.pluginLicenseRepository.getPluginLicense(plugin.getKey()).exists((Predicate<PluginLicense>)((Predicate)PluginLicense::isDataCenter))) {
                return dataCenterVersion;
            }
            return dataCenterVersion.orElse(UpmFugueConverters.toUpmOption(addonsApi.safeGetVersion(plugin.getKey(), AddonVersionSpecifier.latest(), ((AddonVersionsQuery.Builder)queryDefaults.afterVersion(Optional.of(version)).hosting((Optional)Optional.of(HostingType.SERVER))).build())));
        }
        return UpmFugueConverters.toUpmOption(addonsApi.safeGetVersion(plugin.getKey(), AddonVersionSpecifier.latest(), ((AddonVersionsQuery.Builder)queryDefaults.afterVersion(Optional.of(version)).hosting((Optional)Optional.of(HostingType.SERVER))).build()));
    }

    @Override
    public Iterable<AvailableAddonWithVersion> getPlugins(Iterable<String> pluginKeys) {
        return this.getPluginsInternal(pluginKeys, true);
    }

    @Override
    public Iterable<AvailableAddonWithVersion> getLatestVersionOfPlugins(Iterable<String> pluginKeys) {
        return this.getPluginsInternal(pluginKeys, false);
    }

    private Iterable<AvailableAddonWithVersion> getPluginsInternal(Iterable<String> pluginKeys, boolean withCompatibility) {
        if (!this.isPacReachable()) {
            return ImmutableList.of();
        }
        Iterable callables = com.google.common.collect.Iterables.transform(pluginKeys, this.toAvailablePluginCallables(withCompatibility));
        try {
            return ImmutableList.copyOf(Options.catOptions(this.getAsync().invokeAll(callables, this.PLUGIN_DETAILS_TIMEOUT)));
        }
        catch (RuntimeTimeoutException ex) {
            this.logger.debug("Timeout while accessing plugins API: " + (Object)((Object)ex));
            return ImmutableList.of();
        }
    }

    private ApplicationKey getMarketplaceApplicationKey() {
        return ApplicationKeyUtils.getMarketplaceApplicationKey(ApplicationKey.valueOf(this.applicationProperties.getDisplayName()));
    }

    private Iterable<Plugin> getUpdatablePlugins() {
        Iterable<Plugin> installedPlugins = this.pluginRetriever.getPlugins();
        return ImmutableList.copyOf((Iterable)com.google.common.collect.Iterables.filter(installedPlugins, this.isIncludedInUpdateCheck(this.getApplicationRelatedPluginKeys(installedPlugins))));
    }

    private Iterable<String> getUpdatablePluginKeys() {
        return com.google.common.collect.Iterables.transform(this.getUpdatablePlugins(), Plugin::getKey);
    }

    private Iterable<String> getApplicationRelatedPluginKeys(Iterable<Plugin> plugins) {
        return this.appManager.getApplicationRelatedPlugins(com.google.common.collect.Iterables.transform(plugins, Plugins.toPlugPlugin)).keySet();
    }

    private Predicate<Plugin> isIncludedInUpdateCheck(Iterable<String> applicationRelatedPluginKeys) {
        return Predicates.and((Predicate[])new Predicate[]{Predicates.not(Plugins.waitingForRestart()), Predicates.not(this.applicationRelatedPlugin(applicationRelatedPluginKeys)), Predicates.or((Predicate[])new Predicate[]{Plugins.userInstalled(this.metadata), Plugins.upmPlugin(), Plugins.optional(this.metadata)})});
    }

    @Override
    public Iterable<ApplicationVersion> getProductUpdates() throws MpacException {
        if (this.isPacReachable()) {
            int currentBuild = this.getMpacAppBuildNumber();
            Page<ApplicationVersion> results = this.mpacV2ClientFactory.getMarketplaceClient().applications().getVersions(this.getMarketplaceApplicationKey(), ((ApplicationVersionsQuery.Builder)ApplicationVersionsQuery.builder().afterBuildNumber(Optional.of(currentBuild)).bounds(QueryBounds.limit(Optional.of(50))).hosting((Optional)(this.hostApplicationInformation.isHostDataCenterEnabled() ? Optional.of(HostingType.DATA_CENTER) : Optional.empty()))).build());
            Object allResults = ImmutableList.of();
            while (!com.google.common.collect.Iterables.isEmpty(results)) {
                allResults = com.google.common.collect.Iterables.concat((Iterable)allResults, results);
                Optional<PageReference<ApplicationVersion>> maybeNext = results.safeGetNext();
                if (maybeNext.isPresent()) {
                    results = this.mpacV2ClientFactory.getMarketplaceClient().getMore(maybeNext.get());
                    continue;
                }
                results = Page.empty();
            }
            return allResults;
        }
        return ImmutableList.of();
    }

    @Override
    public ProductUpdatePluginCompatibility getProductUpdatePluginCompatibility(Iterable<Plugin> installedPlugins, int buildNumber) throws MpacException {
        if (!this.isPacReachable()) {
            return new ProductUpdatePluginCompatibility.Builder().build();
        }
        Iterable<Plugin> sortedPlugins = this.sort(installedPlugins);
        return this.createProductUpdatePluginCompatibilityStatuses(sortedPlugins, buildNumber);
    }

    @Override
    public Iterable<IncompatiblePluginData> getIncompatiblePlugins(Iterable<String> skipList) {
        if (!this.isPacReachable()) {
            return ImmutableList.of();
        }
        Iterable<Plugin> installedPlugins = this.sort(com.google.common.collect.Iterables.filter(this.pluginRetriever.getPlugins(), (Predicate)Predicates.and(Plugins.userInstalled(this.metadata), (Predicate)Predicates.not(this.pluginAlreadyChecked(skipList)))));
        return this.getIncompatiblePluginsInternal(installedPlugins);
    }

    private Iterable<IncompatiblePluginData> getIncompatiblePluginsInternal(Iterable<Plugin> installedPlugins) {
        if (!this.isPacReachable()) {
            return ImmutableList.of();
        }
        Iterable callables = com.google.common.collect.Iterables.transform(installedPlugins, this.toIncompatiblePluginCallables);
        try {
            return ImmutableList.copyOf(Options.catOptions(this.getAsync().invokeAll(callables, this.UPDATE_CHECK_TIMEOUT)));
        }
        catch (RuntimeTimeoutException ex) {
            this.logger.debug("Timeout while accessing plugins API: " + (Object)((Object)ex));
            return ImmutableList.of();
        }
    }

    @Override
    public Option<IncompatiblePluginData> getPluginIncompatibility(Plugin installedPlugin) {
        return Iterables.toOption(this.getIncompatiblePluginsInternal((Iterable<Plugin>)ImmutableList.of((Object)installedPlugin)));
    }

    private ProductUpdatePluginCompatibility createProductUpdatePluginCompatibilityStatuses(Iterable<Plugin> installedPlugins, int targetBuild) throws MpacException {
        ProductUpdatePluginCompatibility.Builder compatibilityBuilder = new ProductUpdatePluginCompatibility.Builder();
        Iterable callables = com.google.common.collect.Iterables.transform(installedPlugins, this.toCompatibilityCallables(targetBuild, this.mpacV2ClientFactory.getMarketplaceClient().addons()));
        int currentBuild = this.getMpacAppBuildNumber();
        try {
            for (CompatibilityCheckData pluginData : this.getAsync().invokeAll(callables, this.UPDATE_CHECK_TIMEOUT)) {
                if (pluginData.installedVersionListing.isDefined()) {
                    if (pluginData.installedVersionListing.exists(this.versionCompatibleWithAppVersion(targetBuild))) {
                        compatibilityBuilder.addCompatible(pluginData.installedPlugin);
                        continue;
                    }
                    if (pluginData.latestVersionCompatibleWithTargetProduct.isDefined()) {
                        if (pluginData.latestVersionCompatibleWithTargetProduct.exists(this.versionCompatibleWithAppVersion(currentBuild))) {
                            compatibilityBuilder.addUpdateRequired(pluginData.installedPlugin);
                            continue;
                        }
                        if (pluginData.latestVersionCompatibleWithTargetProduct.exists(this.versionCompatibleWithAppVersion(targetBuild))) {
                            compatibilityBuilder.addUpdateRequiredAfterProductUpdate(pluginData.installedPlugin);
                            continue;
                        }
                        compatibilityBuilder.addIncompatible(pluginData.installedPlugin);
                        continue;
                    }
                    compatibilityBuilder.addIncompatible(pluginData.installedPlugin);
                    continue;
                }
                compatibilityBuilder.addUnknown(pluginData.installedPlugin);
            }
        }
        catch (RuntimeTimeoutException ex) {
            this.logger.debug("Timeout while accessing plugins API: " + (Object)((Object)ex));
        }
        return compatibilityBuilder.build();
    }

    private Predicate<AddonVersion> versionCompatibleWithAppVersion(int buildNumber) {
        return v -> com.google.common.collect.Iterables.any(v.getCompatibilities(), this.compatibleWithAppVersion(v.isDataCenterStatusCompatible() ? HostingType.DATA_CENTER : HostingType.SERVER, buildNumber));
    }

    private Predicate<VersionCompatibility> compatibleWithAppVersion(HostingType hostingType, int buildNumber) {
        return vc -> vc.isCompatibleWith(PacClientImpl.compatibleWithAppKey(this.getMarketplaceApplicationKey()), hostingType, buildNumber);
    }

    private static Predicate<ApplicationKey> compatibleWithAppKey(ApplicationKey appKey) {
        return appKey::equals;
    }

    private Option<IncompatiblePluginData.IncompatibilityType> getIncompatibilityType(AddonVersion v, Option<Plugin> p) {
        if (!com.google.common.collect.Iterables.any(v.getCompatibleApplications(), PacClientImpl.compatibleWithAppKey(this.getMarketplaceApplicationKey()))) {
            return Option.some(IncompatiblePluginData.IncompatibilityType.APPLICATION);
        }
        if (!this.versionCompatibleWithAppVersion(this.getMpacAppBuildNumber()).apply((Object)v)) {
            return Option.some(IncompatiblePluginData.IncompatibilityType.APPLICATION_VERSION);
        }
        if (MarketplacePlugins.isDataCenterIncompatible(v, this.hostApplicationInformation) && !MarketplacePlugins.isLegacyDataCenterIncompatible(v, this.hostApplicationInformation)) {
            return Option.some(IncompatiblePluginData.IncompatibilityType.LEGACY_DATA_CENTER);
        }
        if (MarketplacePlugins.isDataCenterIncompatible(v, this.hostApplicationInformation)) {
            return Option.some(IncompatiblePluginData.IncompatibilityType.DATA_CENTER);
        }
        return Option.none();
    }

    @Override
    public Option<PluginVersionPair> getSpecificAndLatestAvailablePluginVersions(Plugin plugin, String version) {
        try {
            if (this.isPacReachable()) {
                Addons addonsApi = this.mpacV2ClientFactory.getMarketplaceClient().addons();
                AddonQuery addonQuery = this.addonQueryDefaults().build();
                Optional<Addon> maybeAddon = addonsApi.safeGetByKey(plugin.getKey(), addonQuery);
                if (maybeAddon.isPresent()) {
                    Option<AddonVersion> latest = com.google.common.collect.Iterables.contains(this.getUpdatablePluginKeys(), (Object)plugin.getKey()) ? this.getUpdateVersion(addonsApi, plugin, version, AddonVersionsQuery.fromAddonQuery(addonQuery)) : Option.none(AddonVersion.class);
                    Option<AddonVersion> specific = this.getAvailablePluginVersion(plugin.getKey(), version);
                    return Option.some(new PluginVersionPair(maybeAddon.get(), specific, latest));
                }
            }
        }
        catch (MpacException ex) {
            this.logger.debug("Error in accessing plugins API");
        }
        return Option.none();
    }

    private AddonQuery.Builder addonQueryDefaults() {
        AddonQuery.Builder builder = ((AddonQuery.Builder)((AddonQuery.Builder)AddonQuery.builder().application((Optional)Optional.of(this.getMarketplaceApplicationKey()))).appBuildNumber((Optional)Optional.of(this.getMpacAppBuildNumber()))).hosting(Optional.of(HostingType.SERVER)).includeHidden(Optional.of(AddonQuery.IncludeHiddenType.ALL));
        if (this.hostApplicationInformation.isHostDataCenterEnabled()) {
            builder.hosting((List)ImmutableList.of((Object)HostingType.DATA_CENTER, (Object)HostingType.SERVER));
        }
        return builder;
    }

    private Predicate<Plugin> applicationRelatedPlugin(Iterable<String> applicationRelatedPluginKeys) {
        return Predicates.compose((Predicate)Predicates.in((Collection)ImmutableList.copyOf(applicationRelatedPluginKeys)), Plugins.toPluginKey);
    }

    private Predicate<Plugin> pluginAlreadyChecked(Iterable<String> pluginsChecked) {
        return plugin -> com.google.common.collect.Iterables.contains((Iterable)pluginsChecked, (Object)plugin.getKey());
    }

    private HostingType getHostingType(Plugin installedPlugin) {
        return this.hostApplicationInformation.isHostDataCenterEnabled() && (Plugins.isStatusDataCenterCompatibleAccordingToPluginDescriptor(installedPlugin) || this.pluginLicenseRepository.getPluginLicense(installedPlugin.getKey()).exists((Predicate<PluginLicense>)((Predicate)PluginLicense::isDataCenter))) ? HostingType.DATA_CENTER : HostingType.SERVER;
    }

    private Function<Plugin, Callable<CompatibilityCheckData>> toCompatibilityCallables(int targetBuildNumber, Addons addonsApi) {
        return installedPlugin -> () -> {
            try {
                AddonVersionsQuery targetQuery = ((AddonVersionsQuery.Builder)((AddonVersionsQuery.Builder)((AddonVersionsQuery.Builder)AddonVersionsQuery.builder().application((Optional)Optional.of(this.getMarketplaceApplicationKey()))).appBuildNumber((Optional)Optional.of(targetBuildNumber))).hosting((Optional)Optional.of(this.getHostingType((Plugin)installedPlugin)))).build();
                String pluginKey = installedPlugin.getKey();
                AddonVersionsQuery query = AddonVersionsQuery.builder(targetQuery).build();
                Option<AddonVersion> installedVersion = UpmFugueConverters.toUpmOption(addonsApi.safeGetVersion(pluginKey, AddonVersionSpecifier.versionName(installedPlugin.getVersion()), query));
                Option<AddonVersion> latestVersion = UpmFugueConverters.toUpmOption(addonsApi.safeGetVersion(pluginKey, AddonVersionSpecifier.latest(), query));
                return new CompatibilityCheckData((Plugin)installedPlugin, installedVersion, latestVersion);
            }
            catch (MpacException ex) {
                this.logger.debug("Error when retrieving compatible plugin versions from MPAC: " + installedPlugin.getKey(), (Throwable)ex);
                return new CompatibilityCheckData((Plugin)installedPlugin, Option.none(AddonVersion.class), Option.none(AddonVersion.class));
            }
        };
    }

    private Function<String, Callable<Option<AvailableAddonWithVersion>>> toAvailablePluginCallables(boolean withCompatibility) {
        return pluginKey -> () -> {
            try {
                return this.getAvailablePluginInternal((String)pluginKey, withCompatibility);
            }
            catch (MpacException e) {
                this.logger.warn("Error when retrieving available plugin: " + pluginKey + " : " + e);
                return Option.none();
            }
        };
    }

    private Iterable<AvailableAddonWithVersion> sortVersions(Iterable<AvailableAddonWithVersion> listToSort) {
        return Ordering.from((Comparator)this.pluginVersionComparator).sortedCopy(listToSort);
    }

    private Iterable<Plugin> sort(Iterable<Plugin> listToSort) {
        return Ordering.from((Comparator)this.pluginComparator).sortedCopy(listToSort);
    }

    private static int compareStringsNullSafe(String s1, String s2) {
        if (s1 == null || s2 == null) {
            if (s1 == null) {
                return s2 == null ? 0 : -1;
            }
            return 1;
        }
        return s1.compareTo(s2);
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        if (this.async.isInitialized()) {
            this.getAsync().close();
        }
        this.async.reset();
        this.eventPublisher.unregister((Object)this);
    }

    static class MpacApplication {
        final Boolean unknown;
        final Option<Integer> buildNumber;

        MpacApplication(Boolean unknown, Option<Integer> buildNumber) {
            this.unknown = unknown;
            this.buildNumber = buildNumber;
        }
    }

    static class Execution {
        private final ExecutorService executorService;
        private final AsyncCompleter completer;

        Execution(ThreadLocalDelegateExecutorFactory factory) {
            this.executorService = factory.createExecutorService(Executors.newCachedThreadPool(ThreadFactories.namedThreadFactory((String)"UpmPacClient")));
            this.completer = new AsyncCompleter.Builder((Executor)this.executorService).limitParallelExecutionTo(8);
        }

        <T> Iterable<T> invokeAll(Iterable<? extends Callable<T>> jobs, Duration timeout) {
            Iterable lazy = this.completer.invokeAll(jobs, timeout.getMillis(), TimeUnit.MILLISECONDS);
            try {
                return ImmutableList.copyOf((Iterable)lazy);
            }
            catch (LazyReference.InitializationException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new UndeclaredThrowableException(e.getCause(), "Invoking async jobs failed with an unexpected checked exception");
            }
        }

        void close() {
            this.executorService.shutdownNow();
        }
    }

    private static final class SpiPluginComparator
    implements Comparator<Plugin> {
        private SpiPluginComparator() {
        }

        @Override
        public int compare(Plugin plugin1, Plugin plugin2) {
            if (plugin1 == null || plugin2 == null) {
                if (plugin1 == null) {
                    return plugin2 == null ? 0 : -1;
                }
                return 1;
            }
            int result = PacClientImpl.compareStringsNullSafe(plugin1.getName(), plugin2.getName());
            if (result != 0) {
                return result;
            }
            return PacClientImpl.compareStringsNullSafe(plugin1.getKey(), plugin2.getKey());
        }
    }

    private static final class PluginVersionComparator
    implements Comparator<AvailableAddonWithVersion> {
        private PluginVersionComparator() {
        }

        @Override
        public int compare(AvailableAddonWithVersion plugin1, AvailableAddonWithVersion plugin2) {
            if (plugin1 == null || plugin2 == null) {
                if (plugin1 == null) {
                    return plugin2 == null ? 0 : -1;
                }
                return 1;
            }
            int result = PacClientImpl.compareStringsNullSafe(plugin1.getAddon().getName(), plugin2.getAddon().getName());
            if (result != 0) {
                return result;
            }
            return PacClientImpl.compareStringsNullSafe(plugin1.getAddon().getKey(), plugin2.getAddon().getKey());
        }
    }

    private static class CompatibilityCheckData {
        final Plugin installedPlugin;
        final Option<AddonVersion> installedVersionListing;
        final Option<AddonVersion> latestVersionCompatibleWithTargetProduct;

        public CompatibilityCheckData(Plugin installedPlugin, Option<AddonVersion> installedVersionListing, Option<AddonVersion> latestVersionCompatibleWithTargetProduct) {
            this.installedPlugin = installedPlugin;
            this.installedVersionListing = installedVersionListing;
            this.latestVersionCompatibleWithTargetProduct = latestVersionCompatibleWithTargetProduct;
        }
    }
}

