/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.notification;

import com.atlassian.upm.notification.NotificationCache;
import com.atlassian.upm.notification.NotificationType;
import com.atlassian.upm.notification.PluginRequestNotificationChecker;
import com.atlassian.upm.request.PluginRequest;
import com.atlassian.upm.request.PluginRequestStore;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginRequestNotificationCheckerImpl
implements PluginRequestNotificationChecker {
    private static final Logger log = LoggerFactory.getLogger(PluginRequestNotificationCheckerImpl.class);
    private final NotificationCache cache;
    private final PluginRequestStore pluginRequestStore;

    public PluginRequestNotificationCheckerImpl(NotificationCache cache, PluginRequestStore pluginRequestStore) {
        this.cache = (NotificationCache)Preconditions.checkNotNull((Object)cache, (Object)"cache");
        this.pluginRequestStore = (PluginRequestStore)Preconditions.checkNotNull((Object)pluginRequestStore, (Object)"pluginRequestStore");
    }

    @Override
    public void updatePluginRequestNotifications() {
        try {
            Iterable<PluginRequest> pluginRequests = this.pluginRequestStore.getRequests();
            this.cache.setNotifications(NotificationType.PLUGIN_REQUEST, (Iterable<String>)ImmutableList.copyOf((Iterable)Iterables.transform(pluginRequests, PluginRequest.toPluginKey())));
        }
        catch (Exception e) {
            log.warn("Error getting plugin request notifications", (Throwable)e);
        }
    }
}

