/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.mail.impl;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.Pairs;
import com.atlassian.upm.SysPersisted;
import com.atlassian.upm.UpmSettings;
import com.atlassian.upm.UserSettings;
import com.atlassian.upm.UserSettingsStore;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.mail.EmailType;
import com.atlassian.upm.mail.MailRenderer;
import com.atlassian.upm.mail.ProductMailService;
import com.atlassian.upm.mail.UpmEmail;
import com.atlassian.upm.mail.UpmMailHeaderGenerator;
import com.atlassian.upm.mail.UpmMailSenderService;
import com.atlassian.upm.rest.UpmUriBuilder;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpmMailSenderServiceImpl
implements UpmMailSenderService {
    private static final Logger logger = LoggerFactory.getLogger(UpmMailSenderServiceImpl.class);
    private final ProductMailService mailService;
    private final MailRenderer renderer;
    private final UserManager userManager;
    private final SysPersisted sysPersisted;
    private final UserSettingsStore userSettingsStore;
    private final UpmUriBuilder uriBuilder;
    private final ApplicationProperties applicationProperties;
    private final I18nResolver i18nResolver;
    private Predicate<? super UserProfile> emailIsNotDisabled = new Predicate<UserProfile>(){

        public boolean apply(UserProfile user) {
            return !StringUtils.isBlank((CharSequence)user.getEmail()) && !UpmMailSenderServiceImpl.this.userSettingsStore.getBoolean(user.getUserKey(), UserSettings.DISABLE_EMAIL);
        }
    };
    private Function<UserKey, UserProfile> toUserProfile = new Function<UserKey, UserProfile>(){

        public UserProfile apply(UserKey userKey) {
            return UpmMailSenderServiceImpl.this.userManager.getUserProfile(userKey);
        }
    };

    public UpmMailSenderServiceImpl(ProductMailService mailService, MailRenderer renderer, UserManager userManager, SysPersisted sysPersisted, UserSettingsStore userSettingsStore, UpmUriBuilder uriBuilder, ApplicationProperties applicationProperties, I18nResolver i18nResolver) {
        this.mailService = (ProductMailService)Preconditions.checkNotNull((Object)mailService, (Object)"mailService");
        this.renderer = (MailRenderer)Preconditions.checkNotNull((Object)renderer, (Object)"renderer");
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
        this.sysPersisted = (SysPersisted)Preconditions.checkNotNull((Object)sysPersisted, (Object)"sysPersisted");
        this.userSettingsStore = (UserSettingsStore)Preconditions.checkNotNull((Object)userSettingsStore, (Object)"userSettingsStore");
        this.uriBuilder = (UpmUriBuilder)Preconditions.checkNotNull((Object)uriBuilder, (Object)"uriBuilder");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
    }

    @Override
    public boolean canSendEmail() {
        return !this.sysPersisted.is(UpmSettings.EMAIL_DISABLED) && this.mailService.isConfigured() && !this.mailService.isDisabled();
    }

    @Override
    public void sendUpmEmail(EmailType mailType, Pairs.Pair<String, String> pluginKeyAndName, Set<UserKey> recipients, Iterable<String> subjectArgs, Map<String, Object> bodyContext) {
        ImmutableSet filteredRecipients = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(recipients, this.toUserProfile), (Predicate)Predicates.and((Predicate)Predicates.notNull(), this.emailIsNotDisabled)));
        String subject = this.renderer.renderEmailSubject(mailType, subjectArgs);
        Option<UserProfile> senderProfile = this.getSenderProfile();
        for (UserProfile recipient : filteredRecipients) {
            UpmEmail.Format emailFormat = this.mailService.getUserEmailFormatPreference(recipient.getUserKey());
            String body = this.renderer.renderEmailBody(mailType, emailFormat, this.buildContext(mailType, senderProfile, recipient, pluginKeyAndName, bodyContext));
            UpmEmail.Builder email = UpmEmail.builder(subject, body).fromName(Option.some(this.i18nResolver.getText("upm.marketplace.title", new Serializable[]{this.applicationProperties.getDisplayName()}))).addTo(recipient.getEmail()).addHeaders(UpmMailHeaderGenerator.generateMailHeader(mailType, pluginKeyAndName.getFirst())).mimeType(emailFormat.getMimeType()).encoding("UTF-8");
            for (UserProfile sender : senderProfile) {
                if (StringUtils.isBlank((CharSequence)sender.getEmail())) continue;
                email.addReplyTo(sender.getEmail());
            }
            try {
                this.mailService.sendMail(email.build());
            }
            catch (Exception e) {
                logger.warn("Failed to send email {} : {}", (Object)mailType, (Object)e.toString());
                logger.debug(e.toString(), (Throwable)e);
            }
        }
    }

    private Option<UserProfile> getSenderProfile() {
        return Option.option(this.userManager.getRemoteUser());
    }

    private Map<String, Object> buildContext(EmailType emailType, Option<UserProfile> senderProfile, UserProfile recipientProfile, Pairs.Pair<String, String> pluginKeyAndName, Map<String, Object> moreContext) {
        ImmutableMap.Builder context = ImmutableMap.builder();
        context.put((Object)"recipient", (Object)recipientProfile).put((Object)"pluginKey", (Object)pluginKeyAndName.getFirst()).put((Object)"pluginName", (Object)pluginKeyAndName.getSecond()).put((Object)"userSettingsLink", (Object)this.uriBuilder.emailUri(this.uriBuilder.buildUpmUserSettingsUri(), emailType)).put((Object)"singlePluginViewLink", (Object)this.uriBuilder.emailUri(this.uriBuilder.buildUpmSinglePluginViewUri(pluginKeyAndName.getFirst()), emailType)).put((Object)"managePluginLink", (Object)this.uriBuilder.emailUri(this.uriBuilder.buildUpmTabPluginUri("manage", pluginKeyAndName.getFirst()), emailType)).put((Object)"isOnDemand", (Object)false);
        for (String instanceName : this.mailService.getInstanceName()) {
            context.put((Object)"instanceName", (Object)instanceName);
        }
        for (UserProfile sender : senderProfile) {
            context.put((Object)"sender", (Object)sender);
        }
        HashMap map = Maps.newHashMap((Map)context.build());
        map.putAll(moreContext);
        return ImmutableMap.copyOf((Map)map);
    }
}

