/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.mail;

import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.mail.AbstractAtlassianMailService;
import com.atlassian.upm.mail.UpmEmail;
import com.google.common.base.Preconditions;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class ConfluenceMailService
extends AbstractAtlassianMailService {
    public static final String MAIL = "mail";
    private final MultiQueueTaskManager taskManager;
    private final UserAccessor userAccessor;
    private final SettingsManager settingsManager;

    public ConfluenceMailService(MultiQueueTaskManager taskManager, UserAccessor userAccessor, SettingsManager settingsManager) {
        this.taskManager = (MultiQueueTaskManager)Preconditions.checkNotNull((Object)taskManager, (Object)"taskManager");
        this.userAccessor = (UserAccessor)Preconditions.checkNotNull((Object)userAccessor, (Object)"userAccessor");
        this.settingsManager = (SettingsManager)Preconditions.checkNotNull((Object)settingsManager, (Object)"settingsManager");
    }

    @Override
    public void sendMail(UpmEmail email) {
        this.taskManager.addTask(MAIL, (Task & Serializable)() -> this.createMailQueueItem(email).send());
    }

    @Override
    public UpmEmail.Format getUserEmailFormatPreference(UserKey userKey) {
        String mimePref;
        PropertySet propertySet = this.userAccessor.getPropertySet(this.userAccessor.getUser(userKey.getStringValue()));
        if (propertySet != null && StringUtils.isNotBlank((CharSequence)(mimePref = propertySet.getString("confluence.prefs.email.mimetype"))) && UpmEmail.Format.TEXT.getMimeType().equals(mimePref)) {
            return UpmEmail.Format.TEXT;
        }
        return UpmEmail.Format.HTML;
    }

    @Override
    public Option<String> getInstanceName() {
        return Option.some(this.settingsManager.getGlobalSettings().getSiteTitle());
    }
}

