/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.mail;

import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.upm.mail.ProductUserLists;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;

public class BambooUserLists
implements ProductUserLists {
    private final BambooPermissionManager bambooPermissionManager;
    private final BambooUserManager bambooUserManager;
    private final Function<String, Iterable<UserKey>> toAdminList = new Function<String, Iterable<UserKey>>(){

        public Iterable<UserKey> apply(String adminGroup) {
            return Iterables.transform((Iterable)BambooUserLists.this.bambooUserManager.getMemberNamesAsList(BambooUserLists.this.bambooUserManager.getGroup(adminGroup)), UserKey::new);
        }
    };

    public BambooUserLists(BambooPermissionManager bambooPermissionManager, BambooUserManager bambooUserManager) {
        this.bambooPermissionManager = (BambooPermissionManager)Preconditions.checkNotNull((Object)bambooPermissionManager, (Object)"bambooPermissionManager");
        this.bambooUserManager = (BambooUserManager)Preconditions.checkNotNull((Object)bambooUserManager, (Object)"bambooUserManager");
    }

    @Override
    public Set<UserKey> getSystemAdmins() {
        return this.getAdminsAndSystemAdmins();
    }

    @Override
    public Set<UserKey> getAdminsAndSystemAdmins() {
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)this.bambooPermissionManager.getAdminGroups(), this.toAdminList)));
    }
}

