/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal.impl;

import com.atlassian.upm.license.internal.LicenseDateFormatter;
import com.atlassian.upm.license.internal.LicenseDatePreferenceProvider;
import com.google.common.base.Preconditions;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class LicenseDateFormatterImpl
implements LicenseDateFormatter {
    private LicenseDatePreferenceProvider licenseDatePreferenceProvider;

    public LicenseDateFormatterImpl(LicenseDatePreferenceProvider licenseDatePreferenceProvider) {
        this.licenseDatePreferenceProvider = (LicenseDatePreferenceProvider)Preconditions.checkNotNull((Object)licenseDatePreferenceProvider, (Object)"licenseDatePreferenceProvider");
    }

    @Override
    public String formatDateTime(DateTime licenseDate) {
        return this.formatInternal(licenseDate, this.licenseDatePreferenceProvider.getDateTimeFormat());
    }

    @Override
    public String formatDate(DateTime licenseDate) {
        return this.formatInternal(licenseDate, this.licenseDatePreferenceProvider.getDateFormat());
    }

    private String formatInternal(DateTime licenseDate, String format) {
        Preconditions.checkNotNull((Object)licenseDate, (Object)"licenseDate");
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format).withZone(this.licenseDatePreferenceProvider.getUserTimeZone());
        return formatter.print(licenseDate.getMillis());
    }
}

