/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.upm.license.internal.impl.DefaultLicenseDateFormatter;
import com.google.common.base.Preconditions;
import org.joda.time.DateTime;

public class JiraLicenseDateFormatter
extends DefaultLicenseDateFormatter {
    private final DateTimeFormatter dateTimeFormatter;

    public JiraLicenseDateFormatter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = (DateTimeFormatter)Preconditions.checkNotNull((Object)dateTimeFormatter, (Object)"dateTimeFormatter");
    }

    @Override
    public String formatDateTime(DateTime licenseDate) {
        return this.formatDateInternal(licenseDate, DateTimeStyle.COMPLETE);
    }

    @Override
    public String formatDate(DateTime licenseDate) {
        return this.formatDateInternal(licenseDate, DateTimeStyle.DATE);
    }

    private String formatDateInternal(DateTime licenseDate, DateTimeStyle style) {
        return this.dateTimeFormatter.forLoggedInUser().withStyle(style).format(licenseDate.toDate());
    }
}

