/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.rest.async;

import com.atlassian.upm.core.async.AsyncTaskErrorInfo;
import com.atlassian.upm.core.async.AsyncTaskInfo;
import com.atlassian.upm.core.async.AsyncTaskStatus;
import com.atlassian.upm.core.rest.BaseUriBuilder;
import com.atlassian.upm.core.rest.async.AsyncTaskCollectionRepresentation;
import com.atlassian.upm.core.rest.async.AsyncTaskRepresentation;
import com.atlassian.upm.core.rest.async.AsyncTaskRepresentationFactory;
import com.atlassian.upm.core.rest.async.LegacyAsyncTaskCollectionRepresentation;
import com.atlassian.upm.core.rest.async.LegacyAsyncTaskRepresentation;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;

public class AsyncTaskRepresentationFactoryImpl
implements AsyncTaskRepresentationFactory {
    private final BaseUriBuilder uriBuilder;

    public AsyncTaskRepresentationFactoryImpl(BaseUriBuilder uriBuilder) {
        this.uriBuilder = uriBuilder;
    }

    @Override
    public AsyncTaskRepresentation createAsyncTaskRepresentation(AsyncTaskInfo taskInfo, boolean isAdmin) {
        AsyncTaskStatus status = taskInfo.getStatus();
        ImmutableMap.Builder links = ImmutableMap.builder();
        links.put((Object)"self", (Object)this.uriBuilder.buildPendingTaskUri(taskInfo.getId()));
        for (URI resultUri : taskInfo.getStatus().getResultUri()) {
            links.put((Object)"result", (Object)resultUri);
        }
        for (URI nextUri : taskInfo.getStatus().getNextStepPostUri()) {
            links.put((Object)"nextStepPost", (Object)nextUri);
        }
        return new AsyncTaskRepresentation((Map<String, URI>)links.build(), status.isDone(), status.getError().getOrElse((AsyncTaskErrorInfo)null), taskInfo.getType().name(), status.getDescription().getOrElse((String)null), status.getItemsDone().getOrElse((Integer)null), status.getItemsTotal().getOrElse((Integer)null), status.getProgress().getOrElse((Float)null), status.getPollDelay(), taskInfo.getTimestamp(), isAdmin ? taskInfo.getUserKey() : null);
    }

    @Override
    public AsyncTaskCollectionRepresentation createAsyncTaskCollectionRepresentation(Iterable<AsyncTaskInfo> tasks, final boolean isAdmin) {
        Iterable reps = Iterables.transform(tasks, (Function)new Function<AsyncTaskInfo, AsyncTaskRepresentation>(){

            public AsyncTaskRepresentation apply(AsyncTaskInfo task) {
                return AsyncTaskRepresentationFactoryImpl.this.createAsyncTaskRepresentation(task, isAdmin);
            }
        });
        return new AsyncTaskCollectionRepresentation(reps, this.uriBuilder);
    }

    @Override
    public LegacyAsyncTaskRepresentation createLegacyAsyncTaskRepresentation(AsyncTaskInfo taskInfo) {
        return new LegacyAsyncTaskRepresentation(taskInfo, this.uriBuilder);
    }

    @Override
    public LegacyAsyncTaskCollectionRepresentation createLegacyAsyncTaskCollectionRepresentation(Iterable<AsyncTaskInfo> tasks) {
        Iterable reps = Iterables.transform(tasks, (Function)new Function<AsyncTaskInfo, LegacyAsyncTaskRepresentation>(){

            public LegacyAsyncTaskRepresentation apply(AsyncTaskInfo task) {
                return AsyncTaskRepresentationFactoryImpl.this.createLegacyAsyncTaskRepresentation(task);
            }
        });
        return new LegacyAsyncTaskCollectionRepresentation(reps, this.uriBuilder);
    }
}

