/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.analytics.event;

import com.atlassian.upm.api.util.Pair;
import com.atlassian.upm.core.analytics.AnalyticsEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;

public class DefaultAnalyticsEvent
implements AnalyticsEvent {
    private final String type;
    private final Map<String, String> metadata;

    public DefaultAnalyticsEvent(String type) {
        this(type, (Map<String, String>)ImmutableMap.of());
    }

    public DefaultAnalyticsEvent(String type, Map<String, String> metadata) {
        this.type = type;
        this.metadata = ImmutableMap.copyOf(metadata);
    }

    @Override
    public boolean isRecordedByMarketplace() {
        return false;
    }

    @Override
    public String getEventType() {
        return this.type;
    }

    @Override
    public Iterable<Pair<String, String>> getInvolvedPluginVersions() {
        return ImmutableList.of();
    }

    @Override
    public Iterable<AnalyticsEvent.AnalyticsEventInfo> getInvolvedPluginInfo() {
        return ImmutableList.of();
    }

    @Override
    public Iterable<Pair<String, String>> getMetadata() {
        return Iterables.transform(this.metadata.entrySet(), Pair.fromMapEntry());
    }
}

