/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core;

import com.atlassian.marketplace.client.model.Addon;
import com.atlassian.marketplace.client.model.AddonVersionBase;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginRestartState;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.upm.PluginControlHandlerRegistry;
import com.atlassian.upm.PluginInfoUtils;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.DefaultHostApplicationInformation;
import com.atlassian.upm.core.HostApplicationDescriptor;
import com.atlassian.upm.core.HostingType;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginMetadataAccessor;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.core.install.ConnectPluginControlHandlerRegistryImpl;
import com.atlassian.upm.license.LicensedPlugins;
import com.atlassian.upm.spi.PluginControlHandler;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Ordering;
import java.text.Collator;
import java.util.Dictionary;
import java.util.Locale;

public abstract class Plugins {
    public static final String PLUGIN_INFO_LEGACY_DATA_CENTER_COMPATIBLE_KEY_PARAM = "atlassian-data-center-compatible";
    public static Function<Plugin, String> toPluginKey = new Function<Plugin, String>(){

        public String apply(Plugin plugin) {
            return plugin.getKey();
        }
    };
    public static Function<Plugin, String> toPluginName = new Function<Plugin, String>(){

        public String apply(Plugin plugin) {
            return plugin.getName();
        }
    };
    public static Function<com.atlassian.plugin.Plugin, String> plugToPluginKey = new Function<com.atlassian.plugin.Plugin, String>(){

        public String apply(com.atlassian.plugin.Plugin plugin) {
            return plugin.getKey();
        }
    };
    public static Function<Plugin, com.atlassian.plugin.Plugin> toPlugPlugin = Plugin::getPlugin;

    public static boolean isConnectPlugin(com.atlassian.plugin.Plugin plugin, PluginControlHandlerRegistry pluginControlHandlerRegistry) {
        Dictionary headers;
        if (plugin instanceof OsgiPlugin && (headers = ((OsgiPlugin)plugin).getBundle().getHeaders()).get("Atlassian-Connect-Addon") != null) {
            return true;
        }
        if (pluginControlHandlerRegistry instanceof ConnectPluginControlHandlerRegistryImpl) {
            for (PluginControlHandler controller : pluginControlHandlerRegistry.getHandlers()) {
                if (!controller.canControl(plugin.getKey())) continue;
                return true;
            }
        }
        return Plugins.isXmlConnectAddon(plugin);
    }

    public static boolean isXmlConnectAddon(com.atlassian.plugin.Plugin plugin) {
        Dictionary headers;
        return plugin instanceof OsgiPlugin && (headers = ((OsgiPlugin)plugin).getBundle().getHeaders()).get("Remote-Plugin") != null;
    }

    public static Predicate<Plugin> enabled(final boolean enabled, final PluginRetriever pluginRetriever) {
        return new Predicate<Plugin>(){

            public boolean apply(Plugin plugin) {
                return enabled == pluginRetriever.isPluginEnabled(plugin.getKey());
            }
        };
    }

    public static Predicate<Plugin> userInstalled(final PluginMetadataAccessor metadata) {
        return new Predicate<Plugin>(){

            public boolean apply(Plugin plugin) {
                return metadata.isUserInstalled(plugin);
            }
        };
    }

    public static Predicate<Plugin> licensingEnabled(final UpmAppManager appManager) {
        return new Predicate<Plugin>(){

            public boolean apply(Plugin plugin) {
                return LicensedPlugins.usesLicensing(plugin.getPlugin(), appManager);
            }
        };
    }

    public static Predicate<Plugin> optional(final PluginMetadataAccessor metadata) {
        return new Predicate<Plugin>(){

            public boolean apply(Plugin plugin) {
                return metadata.isOptional(plugin);
            }
        };
    }

    public static Predicate<Plugin> upmPlugin() {
        return new Predicate<Plugin>(){

            public boolean apply(Plugin plugin) {
                return plugin.isUpmPlugin();
            }
        };
    }

    public static Predicate<Plugin> waitingForRestart() {
        return new Predicate<Plugin>(){

            public boolean apply(Plugin plugin) {
                return Plugins.hasRestartRequiredChange(plugin);
            }
        };
    }

    public static boolean hasRestartRequiredChange(Plugin plugin) {
        return !PluginRestartState.NONE.equals((Object)plugin.getRestartState());
    }

    public static Function<String, Option<Plugin>> toInstalledPlugin(final PluginRetriever retriever) {
        return new Function<String, Option<Plugin>>(){

            public Option<Plugin> apply(String key) {
                return retriever.getPlugin(key);
            }
        };
    }

    public static boolean isStatusDataCenterCompatibleAccordingToPluginDescriptor(Plugin plugin) {
        return PluginInfoUtils.isStatusDataCenterCompatibleAccordingToPluginDescriptor(plugin.getPluginInformation());
    }

    public static boolean isLegacyDataCenterCompatibleAccordingToPluginDescriptor(Plugin plugin) {
        return PluginInfoUtils.getBooleanPluginInfoParam(plugin.getPluginInformation(), PLUGIN_INFO_LEGACY_DATA_CENTER_COMPATIBLE_KEY_PARAM);
    }

    public static HostingType getPluginHostingType(PluginInformation pluginInformation, DefaultHostApplicationInformation hostApplicationInformation) {
        return PluginInfoUtils.isStatusDataCenterCompatibleAccordingToPluginDescriptor(pluginInformation) ? hostApplicationInformation.getHostingType() : HostingType.SERVER;
    }

    public static HostingType getAddonHostingType(Addon addon, DefaultHostApplicationInformation hostApplicationInformation) {
        return (HostingType)((Object)addon.getVersion().filter(AddonVersionBase::isDataCenterStatusCompatible).map(av -> hostApplicationInformation.getHostingType()).getOrElse((Object)HostingType.SERVER));
    }

    public static Predicate<Integer> hasCloudFreeUsers(final HostApplicationDescriptor hostApplicationDescriptor) {
        return new Predicate<Integer>(){

            public boolean apply(Integer cloudFreeUsers) {
                return hostApplicationDescriptor.getActiveEditionCount() <= cloudFreeUsers;
            }
        };
    }

    public static final class PluginOrdering
    extends Ordering<Plugin> {
        private final Collator collator;

        public PluginOrdering(Locale locale) {
            this.collator = Collator.getInstance(locale);
        }

        public int compare(Plugin p1, Plugin p2) {
            int result = this.collator.compare(PluginOrdering.getNameOrKey(p1), PluginOrdering.getNameOrKey(p2));
            return result != 0 ? result : this.collator.compare(p1.getKey(), p2.getKey());
        }

        private static String getNameOrKey(Plugin p) {
            String name = p.getName();
            return name != null ? name : p.getKey();
        }
    }
}

