/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collection;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class BundledUpdateInfo {
    @JsonProperty
    private final int platformTargetBuildNumber;
    @JsonProperty
    private final Collection<UpdateItem> updateItems;

    @JsonCreator
    public BundledUpdateInfo(@JsonProperty(value="platformTargetBuildNumber") int platformTargetBuildNumber, @JsonProperty(value="updateItems") Collection<UpdateItem> updateItems) {
        this.platformTargetBuildNumber = (Integer)Preconditions.checkNotNull((Object)platformTargetBuildNumber, (Object)"platformTargetBuildNumber");
        this.updateItems = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(updateItems, (Object)"updateItems")));
    }

    public int getPlatformTargetBuildNumber() {
        return this.platformTargetBuildNumber;
    }

    @JsonIgnore
    public Iterable<UpdateItem> getUpdateItems() {
        return this.updateItems;
    }

    public String toString() {
        return "BundledUpdateInfo(" + this.platformTargetBuildNumber + ", " + Joiner.on((String)", ").join(this.updateItems) + ")";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof BundledUpdateInfo && other.toString().equals(this.toString());
    }

    public static class UpdateItem {
        @JsonProperty
        private final String pluginKey;
        @JsonProperty
        private final String name;
        @JsonProperty
        private final String version;
        @JsonProperty
        private final URI uri;

        @JsonCreator
        public UpdateItem(@JsonProperty(value="pluginKey") String pluginKey, @JsonProperty(value="name") String name, @JsonProperty(value="version") String version, @JsonProperty(value="uri") URI uri) {
            this.pluginKey = pluginKey;
            this.name = name;
            this.version = version;
            this.uri = uri;
        }

        public String getPluginKey() {
            return this.pluginKey;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public URI getUri() {
            return this.uri;
        }

        public String toString() {
            return "UpdateItem(" + this.pluginKey + ", " + this.name + ", " + this.version + ", " + this.uri + ")";
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof UpdateItem && other.toString().equals(this.toString());
        }
    }
}

