/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.analytics.logger;

import com.atlassian.upm.analytics.event.PluginUpdateCheckAnalyticsEvent;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.core.analytics.AnalyticsEvent;
import com.atlassian.upm.core.analytics.event.PluginAnalyticsEvent;
import com.atlassian.upm.core.analytics.impl.DefaultAnalyticsLogger;
import com.atlassian.upm.license.internal.PluginLicenseRepository;
import com.google.common.base.Preconditions;

public class UpmAnalyticsLogger
extends DefaultAnalyticsLogger {
    private PluginLicenseRepository pluginLicenseRepository;

    public UpmAnalyticsLogger(PluginLicenseRepository pluginLicenseRepository) {
        this.pluginLicenseRepository = (PluginLicenseRepository)Preconditions.checkNotNull((Object)pluginLicenseRepository, (Object)"pluginLicenseRepository");
    }

    @Override
    public void log(AnalyticsEvent event) {
        if (event instanceof PluginAnalyticsEvent) {
            PluginAnalyticsEvent p2 = (PluginAnalyticsEvent)event;
            p2.setSen(this.pluginLicenseRepository.getPluginLicense(p2.getPluginKey()).flatMap(PluginLicense::getSupportEntitlementNumber).filter(s -> !s.isEmpty()));
        } else if (event instanceof PluginUpdateCheckAnalyticsEvent) {
            ((PluginUpdateCheckAnalyticsEvent)event).getInvolvedPluginInfo().forEach(p -> p.setSen(this.pluginLicenseRepository.getPluginLicense(p.getPluginKey()).flatMap(PluginLicense::getSupportEntitlementNumber).filter(s -> !s.isEmpty())));
        }
        super.log(event);
    }
}

