/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.templaterenderer.plugins;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.module.ModuleFactory;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import javax.inject.Inject;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateContextItemModuleDescriptor
extends AbstractModuleDescriptor<Object>
implements StateAware {
    private Logger log = LoggerFactory.getLogger(TemplateContextItemModuleDescriptor.class);
    private boolean global = false;
    private String contextKey;
    private Supplier<Object> contextItem = null;
    private final BundleContext bundleContext;

    @Inject
    public TemplateContextItemModuleDescriptor(ModuleFactory moduleFactory, BundleContext bundleContext) {
        super(moduleFactory);
        this.bundleContext = bundleContext;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        Attribute contextKeyAtt;
        super.init(plugin, element);
        Attribute globalAtt = element.attribute("global");
        if (globalAtt != null) {
            this.global = Boolean.parseBoolean(globalAtt.getValue());
        }
        if ((contextKeyAtt = element.attribute("context-key")) == null) {
            throw new PluginParseException("context-key must be specified");
        }
        this.contextKey = contextKeyAtt.getValue();
        final Attribute componentImportRefAttr = element.attribute("component-import");
        final Attribute componentRefAttr = element.attribute("component-ref");
        Attribute classAttr = element.attribute("class");
        if (componentImportRefAttr != null) {
            this.contextItem = new Supplier<Object>(){

                public Object get() {
                    ServiceReference ref = TemplateContextItemModuleDescriptor.this.bundleContext.getServiceReference(componentImportRefAttr.getValue());
                    return ref != null ? TemplateContextItemModuleDescriptor.this.bundleContext.getService(ref) : null;
                }
            };
        } else if (componentRefAttr != null) {
            this.contextItem = new Supplier<Object>(){

                public Object get() {
                    if (TemplateContextItemModuleDescriptor.this.getPlugin() instanceof ContainerManagedPlugin) {
                        return ((ContainerManagedPlugin)TemplateContextItemModuleDescriptor.this.getPlugin()).getContainerAccessor().getBean(componentRefAttr.getValue());
                    }
                    throw new IllegalStateException("Plugin isn't a container-managed plugin");
                }
            };
        } else if (classAttr != null) {
            Suppliers.memoize((Supplier)new Supplier<Object>(){

                public Object get() {
                    return TemplateContextItemModuleDescriptor.this.moduleFactory.createModule(TemplateContextItemModuleDescriptor.this.getModuleClassName(), (ModuleDescriptor)TemplateContextItemModuleDescriptor.this);
                }
            });
        } else {
            throw new PluginParseException("You must specify a class or a component-ref");
        }
    }

    public synchronized Object getModule() {
        return this.contextItem.get();
    }

    public synchronized void disabled() {
        super.disabled();
        this.contextItem = null;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public String getContextKey() {
        return this.contextKey;
    }
}

