/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.synchrony.proxy.web;

import com.atlassian.synchrony.proxy.util.SynchronyConfigInfo;
import com.atlassian.synchrony.proxy.util.SynchronyProxyPropertiesHelper;
import com.atlassian.synchrony.proxy.web.HealthCheckResult;
import com.atlassian.synchrony.proxy.web.SynchronyProxyConfigPayload;
import com.atlassian.synchrony.proxy.web.SynchronyProxyFilter;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.Properties;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.ServletContextAware;

@RestController
public class SynchronyProxyRestController
implements ServletContextAware {
    private static final Logger log = LoggerFactory.getLogger(SynchronyProxyRestController.class);
    private ServletContext servletContext;
    private final SynchronyProxyFilter synchronyProxyFilter;

    @Autowired
    public SynchronyProxyRestController(SynchronyProxyFilter synchronyProxyFilter) {
        this.synchronyProxyFilter = synchronyProxyFilter;
    }

    @RequestMapping(value={"/healthcheck"})
    public HealthCheckResult getSynchronyProxyInfo() {
        SynchronyConfigInfo info = SynchronyConfigInfo.fromSystemProperties();
        Properties initParams = SynchronyProxyPropertiesHelper.load((ServletContext)this.servletContext);
        return new HealthCheckResult(info.getSynchronyHost(), info.getSynchronyContextPath(), info.getSynchronyPort(), initParams.getProperty("requestBufferSize"), initParams.getProperty("responseBufferSize"));
    }

    @RequestMapping(value={"/reload"}, method={RequestMethod.PUT})
    public ResponseEntity reloadConfiguration(@RequestBody SynchronyProxyConfigPayload configRequest) {
        try {
            Parameters params = new Parameters();
            FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)params.properties().setFileName(this.servletContext.getRealPath("/WEB-INF") + "/WEB-INF/synchrony-proxy.properties")});
            Configuration configuration = (Configuration)builder.getConfiguration();
            if (configRequest.getRequestBufferSize() != null) {
                configuration.setProperty("requestBufferSize", (Object)configRequest.getRequestBufferSize());
            }
            if (configRequest.getResponseBufferSize() != null) {
                configuration.setProperty("responseBufferSize", (Object)configRequest.getResponseBufferSize());
            }
            builder.save();
            this.synchronyProxyFilter.reload();
        }
        catch (ServletException e) {
            log.debug("{}", (Throwable)e);
            log.error("Can't reload the proxy configuration: {}", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
        catch (ConfigurationException cex) {
            log.debug("{}", (Throwable)cex);
            log.error("Can't reload the proxy configuration: {}", (Object)cex.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
        return ResponseEntity.ok().build();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

