/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.spi;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.lang.ArrayUtils;

final class ClassUtils {
    ClassUtils() {
    }

    static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ClassUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ClassUtils.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    static <T> Class<?> getTypeArgumentForGenericInterfaceWithOneTypeParameter(Class<? extends T> childClass, Class<?> interfaceClass) {
        Type[] interfacesWithTypeArguments;
        Type type = childClass;
        Class<?> typeClass = ClassUtils.getClass(type);
        while (!ClassUtils.implementsInterface(interfaceClass, typeClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
            } else {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class rawType = (Class)parameterizedType.getRawType();
                type = rawType.getGenericSuperclass();
            }
            if ((typeClass = ClassUtils.getClass(type)) != null) continue;
            throw new IllegalArgumentException("Unable to find the class for the type " + type);
        }
        if (type instanceof Class) {
            interfacesWithTypeArguments = type.getGenericInterfaces();
        } else {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            interfacesWithTypeArguments = rawType.getGenericInterfaces();
        }
        for (Type interfaceType : interfacesWithTypeArguments) {
            Class<?> foundInterfaceClass = ClassUtils.getClass(interfaceType);
            if (!foundInterfaceClass.equals(interfaceClass)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)interfaceType;
            Type[] typeParameters = parameterizedType.getActualTypeArguments();
            if (typeParameters.length != 1) {
                throw new IllegalArgumentException("Unable to find the class for the type " + type);
            }
            return ClassUtils.getClass(typeParameters[0]);
        }
        throw new IllegalArgumentException("Unable to find the class for the type " + type);
    }

    private static boolean implementsInterface(Class interfaceClass, Class typeClass) {
        return ArrayUtils.indexOf((Object[])typeClass.getInterfaces(), (Object)interfaceClass) > -1;
    }
}

