/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.support.tools.SimpleXsrfTokenGenerator;
import com.atlassian.support.tools.Stage;
import com.atlassian.support.tools.ValidationLog;
import com.atlassian.support.tools.action.SupportActionFactory;
import com.atlassian.support.tools.action.SupportToolsAction;
import com.atlassian.support.tools.action.impl.DefaultSupportActionFactory;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.MailUtility;
import com.atlassian.support.tools.scheduler.SupportScheduledTaskControllerImpl;
import com.atlassian.support.tools.servlet.SafeHttpServletRequestImpl;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SupportToolsViewServlet
extends HttpServlet {
    static final String JIRA_SERAPH_SECURITY_ORIGINAL_URL = "os_security_originalurl";
    static final String CONF_SERAPH_SECURITY_ORIGINAL_URL = "seraph_originalurl";
    private static final Logger log = Logger.getLogger(SupportToolsViewServlet.class);
    private final TemplateRenderer renderer;
    private final SupportActionFactory factory;
    private final SupportApplicationInfo appInfo;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final WebSudoManager webSudoManager;
    private final SimpleXsrfTokenGenerator tokenGenerator;

    public SupportToolsViewServlet(UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer renderer, ApplicationProperties applicationProperties, SupportApplicationInfo appInfo, MailUtility mailUtility, WebSudoManager webSudoManager, SupportScheduledTaskControllerImpl controller) throws GeneralSecurityException {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.appInfo = appInfo;
        this.webSudoManager = webSudoManager;
        this.tokenGenerator = new SimpleXsrfTokenGenerator();
        this.factory = new DefaultSupportActionFactory(appInfo, mailUtility, controller);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.appInfo.initServletInfo(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.initializeHeader(resp);
        try {
            this.webSudoManager.willExecuteWebSudoRequest(req);
            boolean isAdmin = this.performAdminChecks(req, resp);
            if (isAdmin) {
                Map<String, Object> context = this.prepareContext(req);
                SupportToolsAction action = (SupportToolsAction)context.get("action");
                String sessionToken = this.tokenGenerator.generateToken(req);
                String tokenName = this.tokenGenerator.getXsrfTokenName();
                context.put("tokenName", tokenName);
                String token = req.getParameter(tokenName);
                context.put("token", sessionToken);
                if (this.tokenGenerator.validateToken(req, token)) {
                    this.displayResults(req, resp, context);
                } else {
                    context.put("existingParams", req.getParameterMap());
                    if (action.getName().equals("tabs")) {
                        this.renderer.render("/templates/html/xsrf-error.vm", context, (Writer)resp.getWriter());
                    } else {
                        this.renderer.render("/templates/html/xsrf-error-body.vm", context, (Writer)resp.getWriter());
                    }
                }
            }
        }
        catch (WebSudoSessionException wes) {
            resp.sendError(403);
        }
        finally {
            resp.getWriter().flush();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.initializeHeader(resp);
        try {
            this.webSudoManager.willExecuteWebSudoRequest(req);
            Map<String, Object> context = this.prepareContext(req);
            boolean isAdmin = this.performAdminChecks(req, resp);
            if (isAdmin) {
                String sessionToken = this.tokenGenerator.generateToken(req);
                String tokenName = this.tokenGenerator.getXsrfTokenName();
                context.put("tokenName", tokenName);
                context.put("token", sessionToken);
                this.displayResults(req, resp, context);
            }
            resp.getWriter().close();
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(req, resp);
        }
    }

    private boolean performAdminChecks(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String pathInfo = req.getPathInfo();
        String[] tokens = StringUtils.split((String)pathInfo, (char)'/');
        String actionName = tokens == null || tokens.length == 0 ? null : tokens[0];
        SupportToolsAction action = this.factory.getAction(actionName);
        String username = this.userManager.getRemoteUsername(req);
        if (username == null) {
            if (action.getName().equals("tabs")) {
                this.redirectToLogin(req, resp);
            } else {
                this.renderer.render("/templates/html/ajax-not-logged-in.vm", this.prepareContext(req), (Writer)resp.getWriter());
            }
            return false;
        }
        if (this.userManager.isSystemAdmin(username)) {
            return true;
        }
        if (action.getName().equals("tabs")) {
            this.redirectToLogin(req, resp);
        } else {
            this.renderer.render("/templates/html/ajax-no-permission.vm", this.prepareContext(req), (Writer)resp.getWriter());
        }
        return false;
    }

    private Map<String, Object> prepareContext(HttpServletRequest req) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        String pathInfo = req.getPathInfo();
        String[] tokens = StringUtils.split((String)pathInfo, (char)'/');
        Stage stage = tokens == null || tokens.length < 2 ? Stage.START : Stage.lookup(tokens[1]);
        context.put("stage", (Object)stage);
        String actionName = tokens == null || tokens.length == 0 ? null : tokens[0];
        SupportToolsAction action = this.factory.getAction(actionName);
        context.put("action", action);
        if (action.getName().equals("tabs")) {
            context.put("factory", this.factory);
        }
        String baseURL = this.appInfo.getBaseURL(req);
        context.put("servletHomePath", baseURL + req.getServletPath());
        context.put("info", this.appInfo);
        context.put("baseURL", this.appInfo.getBaseURL(req));
        return context;
    }

    protected void displayResults(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> context) throws IOException {
        block7: {
            SupportToolsAction action = (SupportToolsAction)context.get("action");
            Stage stage = (Stage)((Object)context.get("stage"));
            ValidationLog validationLog = new ValidationLog(this.appInfo);
            context.put("validationLog", validationLog);
            SafeHttpServletRequestImpl safeReq = new SafeHttpServletRequestImpl(req);
            action.prepare(context, safeReq, validationLog);
            if (stage == Stage.EXECUTE) {
                action.validate(context, safeReq, validationLog);
                if (validationLog.hasErrors()) {
                    this.renderer.render(action.getErrorTemplatePath(), context, (Writer)resp.getWriter());
                } else {
                    try {
                        action.execute(context, safeReq, validationLog);
                        if (validationLog.hasErrors()) {
                            this.renderer.render(action.getErrorTemplatePath(), context, (Writer)resp.getWriter());
                            break block7;
                        }
                        this.renderer.render(action.getSuccessTemplatePath(), context, (Writer)resp.getWriter());
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        validationLog.addError("Error rendering the page, check your logs for more details.", new Serializable[0]);
                        this.renderer.render(action.getErrorTemplatePath(), context, (Writer)resp.getWriter());
                    }
                }
            } else {
                this.renderer.render(action.getStartTemplatePath(), context, (Writer)resp.getWriter());
            }
        }
    }

    protected void initializeHeader(HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        resp.setDateHeader("Expires", 0L);
        resp.setContentType("text/html;charset=utf-8");
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        URI uri = this.getUri(request);
        this.addSessionAttributes(request, uri.toASCIIString());
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void addSessionAttributes(HttpServletRequest request, String uriString) {
        request.getSession().setAttribute(JIRA_SERAPH_SECURITY_ORIGINAL_URL, (Object)uriString);
        request.getSession().setAttribute(CONF_SERAPH_SECURITY_ORIGINAL_URL, (Object)uriString);
    }
}

