/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.scheduler;

import com.atlassian.support.tools.ValidationLog;
import com.atlassian.support.tools.action.SupportToolsAction;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.scheduler.SupportScheduledTaskController;
import com.atlassian.support.tools.scheduler.settings.AbstractScheduledTaskSettings;
import com.atlassian.support.tools.servlet.SafeHttpServletRequest;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractScheduledAction
implements SupportToolsAction {
    protected final SupportScheduledTaskController controller;
    protected final SupportApplicationInfo info;
    protected static final Map<String, String> frequencyOptions;

    public AbstractScheduledAction(SupportScheduledTaskController controller, SupportApplicationInfo info) {
        this.controller = controller;
        this.info = info;
    }

    @Override
    public void prepare(Map<String, Object> context, SafeHttpServletRequest request, ValidationLog validationLog) {
        context.put("controller", this.controller);
        context.put("info", this.info);
        context.put("settings", this.getSettings());
        context.put("frequencyOptions", frequencyOptions);
    }

    @Override
    public void validate(Map<String, Object> context, SafeHttpServletRequest req, ValidationLog validationLog) {
        int startTimeHour = this.parseStartHour(req);
        int startTimeMinute = this.parseStartMinute(req);
        long frequency = this.parseFrequency(req);
        if (startTimeHour == -1 || startTimeMinute == -1) {
            validationLog.addError("stp.scheduler.invalid.start.time", new Serializable[0]);
        }
        if (frequency < 120000L) {
            validationLog.addError("stp.scheduler.invalid.frequency", new Serializable[0]);
        }
    }

    private long parseFrequency(HttpServletRequest req) {
        String frequencyString = req.getParameter("frequency");
        if ("daily".equals(frequencyString)) {
            return 86400000L;
        }
        if ("weekly".equals(frequencyString)) {
            return 604800000L;
        }
        return this.parseNumber(frequencyString, -1L);
    }

    private long parseNumber(String string, long defaultValue) {
        if (StringUtils.isEmpty((String)string) || !StringUtils.isNumeric((String)string)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private boolean parseEnabled(HttpServletRequest req) {
        return "on".equals(req.getParameter("enabled"));
    }

    @Override
    public void execute(Map<String, Object> context, SafeHttpServletRequest req, ValidationLog validationLog) {
        if (!validationLog.hasErrors()) {
            boolean hasChanged = this.saveSettings(context, req, validationLog);
            if (hasChanged) {
                this.controller.onSettingsChanged(this.getSettings());
                if (this.getSettings().isEnabled()) {
                    String frequencyString = this.info.getText("stp.scheduler.task.frequency.default.message", Long.valueOf(this.getSettings().getFrequencyMs()));
                    if (this.getSettings().getFrequencyMs() == 86400000L) {
                        frequencyString = frequencyOptions.get("daily");
                    } else if (this.getSettings().getFrequencyMs() == 604800000L) {
                        frequencyString = frequencyOptions.get("weekly");
                    }
                    validationLog.addFeedback("stp.scheduler.task.enabled", new Serializable[]{this.info.getText(frequencyString), this.getSettings().getStartTime()});
                } else {
                    validationLog.addFeedback("stp.scheduler.task.disabled", new Serializable[0]);
                }
            } else {
                validationLog.addFeedback("stp.scheduler.task.unchanged", new Serializable[0]);
            }
        }
    }

    protected boolean saveSettings(Map<String, Object> context, HttpServletRequest req, ValidationLog validationLog) {
        Date time;
        boolean isEnabled = this.parseEnabled(req);
        int startTimeHour = this.parseStartHour(req);
        int startTimeMinute = this.parseStartMinute(req);
        long frequency = this.parseFrequency(req);
        boolean hasChanged = false;
        if (isEnabled != this.getSettings().isEnabled()) {
            hasChanged = true;
            this.getSettings().setEnabled(isEnabled);
        }
        if ((time = this.getSettings().getStartTime()).getHours() != startTimeHour || time.getMinutes() != startTimeMinute) {
            hasChanged = true;
            this.getSettings().setStartTime(startTimeHour, startTimeMinute);
        }
        if (this.getSettings().getFrequencyMs() != frequency) {
            hasChanged = true;
            this.getSettings().setFrequency(frequency);
        }
        return hasChanged;
    }

    private int parseStartMinute(HttpServletRequest req) {
        return (int)this.parseNumber(req.getParameter("start-time-minute"), -1L);
    }

    private int parseStartHour(HttpServletRequest req) {
        return (int)this.parseNumber(req.getParameter("start-time-hour"), -1L);
    }

    @Override
    public String getCategory() {
        return "stp.scheduler.title";
    }

    protected abstract AbstractScheduledTaskSettings getSettings();

    static {
        HashMap<String, String> tMap = new HashMap<String, String>();
        tMap.put("daily", "stp.scheduler.frequency.daily");
        tMap.put("weekly", "stp.scheduler.frequency.weekly");
        frequencyOptions = Collections.unmodifiableMap(tMap);
    }
}

