/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.mail;

import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.mail.server.impl.SMTPMailServerImpl;
import com.atlassian.support.tools.salext.mail.ProductAwareEmail;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class AbstractSupportMailQueueItem
implements MailQueueItem,
Comparable<MailQueueItem> {
    private static final Logger log = Logger.getLogger(AbstractSupportMailQueueItem.class);
    protected final Date dateQueued = new Date();
    protected volatile int sendCount = 0;
    protected boolean hasError = false;

    protected AbstractSupportMailQueueItem() {
    }

    public void execute() throws Exception {
        this.send();
    }

    public void send(ProductAwareEmail email) throws MailException {
        ++this.sendCount;
        SMTPMailServerImpl smtpMailServer = new SMTPMailServerImpl(null, "AtlassianSMTP", "Atlassian SMTP Server", null, null, false, "mail.atlassian.com", null, null);
        try {
            SMTPMailServer configuredMailServer = MailFactory.getServerManager().getDefaultSMTPMailServer();
            if (configuredMailServer != null) {
                smtpMailServer = configuredMailServer;
                log.warn((Object)("Sending message via mail server " + smtpMailServer.getHostname()));
            } else {
                log.warn((Object)"No mail server found, using Atlassian mail server.");
            }
        }
        catch (Exception e1) {
            log.error((Object)"Exception retrieving default mail server, using Atlassian mail server.", (Throwable)e1);
        }
        try {
            smtpMailServer.send((Email)email);
            this.hasError = false;
        }
        catch (MailException e) {
            log.error((Object)("Error sending message '" + email.getSubject() + "', see stack trace below for details."));
            this.hasError = true;
            throw e;
        }
    }

    public Date getDateQueued() {
        return this.dateQueued;
    }

    public int getSendCount() {
        return this.sendCount;
    }

    public boolean hasError() {
        return this.hasError;
    }

    @Override
    public int compareTo(MailQueueItem o) {
        return this.dateQueued.compareTo(o.getDateQueued());
    }
}

