/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.bundle;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.bundle.AbstractApplicationFileBundle;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class LegacyAuthenticationConfigurationFileBundle
extends AbstractApplicationFileBundle {
    private static final Logger log = Logger.getLogger(LegacyAuthenticationConfigurationFileBundle.class);
    private final Map<String, String> files;
    private final CrowdDirectoryService dirService;
    private final SupportApplicationInfo info;

    public LegacyAuthenticationConfigurationFileBundle(BundleManifest bundle, String title, String description, SupportApplicationInfo info, CrowdDirectoryService dirService, String ... files) {
        super(bundle, title, description);
        this.dirService = dirService;
        this.info = info;
        this.files = new HashMap<String, String>();
        for (String file : files) {
            this.files.put(file, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFiles() {
        File supportDir = new File(this.info.getApplicationHome(), "logs/support");
        if (!supportDir.exists() && !supportDir.mkdirs()) {
            log.error((Object)("Couldn't create export directory " + supportDir.getAbsolutePath()));
            return null;
        }
        File dirConfigFile = new File(supportDir, "directoryConfigurationSummary.txt");
        try {
            FileWriter configWriter = new FileWriter(dirConfigFile);
            try {
                StringBuilder configString = new StringBuilder();
                List dirs = this.dirService.findAllDirectories();
                if (dirs.isEmpty()) {
                    configString.append("No directories, or something has gone wrong.");
                }
                for (Directory dir : dirs) {
                    configString.append(dir.getName() + "\n=============================\n");
                    for (Map.Entry attribute : dir.getAttributes().entrySet()) {
                        configString.append((String)attribute.getKey());
                        configString.append(": ");
                        configString.append((String)attribute.getValue());
                        configString.append("\n");
                    }
                    configString.append("\n\n");
                }
                configWriter.write(configString.toString());
            }
            catch (IOException e) {
                log.error((Object)("Failed to write directory configuration to " + dirConfigFile.getPath() + "."), (Throwable)e);
            }
            finally {
                configWriter.flush();
                configWriter.close();
            }
            this.files.put(dirConfigFile.getAbsolutePath(), "");
        }
        catch (Exception e) {
            log.error((Object)"Can't generate directory configuration file.", (Throwable)e);
        }
        return this.files;
    }
}

