/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.UnloadableJiraServiceContainer;
import com.atlassian.jira.upgrade.UpgradeHistoryItem;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtils;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtilsImpl;
import com.atlassian.jira.util.system.check.SystemEnvironmentChecklist;
import com.atlassian.jira.util.system.patch.AppliedPatchInfo;
import com.atlassian.jira.util.system.patch.AppliedPatches;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sisyphus.SisyphusPatternSource;
import com.atlassian.sisyphus.SisyphusPatternSourceDecorator;
import com.atlassian.support.tools.hercules.ScanItem;
import com.atlassian.support.tools.properties.PropertyStore;
import com.atlassian.support.tools.properties.SupportInfoAppenderManager;
import com.atlassian.support.tools.properties.SupportInfoXmlKeyResolver;
import com.atlassian.support.tools.salext.AbstractSupportApplicationInfo;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import com.atlassian.support.tools.salext.bundle.DefaultApplicationFileBundle;
import com.atlassian.support.tools.salext.bundle.LegacyAuthenticationConfigurationFileBundle;
import com.atlassian.support.tools.salext.bundle.WildcardApplicationFileBundle;
import com.atlassian.support.tools.salext.license.ApplicationLicenseInfo;
import com.atlassian.support.tools.zip.FileSanitizer;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class JiraApplicationInfo
extends AbstractSupportApplicationInfo {
    private static final String JIRA_ATTACHMENT_LOCATION = "stp.properties.jira.attachment.location";
    private static final String JIRA_BACKUP_LOCATION = "stp.properties.jira.backup.location";
    private static final String JIRA_ENTITYENGINE_LOCATION = "stp.properties.jira.entityengine.location";
    private static final String JIRA_HOME = "stp.properties.jira.home.location";
    private static final String JIRA_INDEX_LOCATION = "stp.properties.jira.index.location";
    private static final String JIRA_LOG_LOCATION = "stp.properties.jira.log.location";
    private final ExtendedSystemInfoUtils utils;
    private final LocaleManager localeManager;
    private final JiraLicenseService licenseService;
    private final DateTimeFormatterFactory factory;
    private OutlookDateManager outlookDateManager;
    private final CrowdDirectoryService dirService;

    public JiraApplicationInfo(JiraLicenseService licenseService, ApplicationProperties applicationProperties, I18nResolver i18nResolver, UserManager userManager, TemplateRenderer renderer, SupportInfoAppenderManager supportInfoAppenderManager, SupportInfoXmlKeyResolver supportInfoXmlKeyResolver, LocaleManager localeManager, DateTimeFormatterFactory factory, OutlookDateManager outlookDateManager, CrowdDirectoryService dirService) {
        super(applicationProperties, i18nResolver, userManager, renderer, supportInfoAppenderManager, supportInfoXmlKeyResolver);
        this.licenseService = licenseService;
        this.localeManager = localeManager;
        this.factory = factory;
        this.outlookDateManager = outlookDateManager;
        this.utils = new ExtendedSystemInfoUtilsImpl((I18nHelper)new I18nBean(Locale.ENGLISH));
        this.dirService = dirService;
    }

    @Override
    public SisyphusPatternSource getPatternSource() throws IOException, ClassNotFoundException, MalformedURLException {
        SisyphusPatternSourceDecorator source = new SisyphusPatternSourceDecorator();
        Proxy proxy = this.getProxy();
        source.add(this.getPatternSourceByURL("https://confluence.atlassian.com/download/attachments/179443532/jira_regex.xml", proxy));
        source.add(this.getPatternSourceByURL("https://confluence.atlassian.com/download/attachments/179443532/greenhopper_regex.xml", proxy));
        return source;
    }

    @Override
    public void initServletInfo(ServletConfig config) {
        super.initServletInfo(config);
        String webInfClassesDir = this.getServletContextPath("WEB-INF/classes");
        this.applicationInfoBundles.add(new DefaultApplicationFileBundle(BundleManifest.APPLICATION_CONFIG, "stp.zip.include.jira.cfg", "stp.zip.include.jira.cfg.description", webInfClassesDir + "/entityengine.xml", webInfClassesDir + "/log4j.properties", this.getApplicationHome() + "/dbconfig.xml"));
        String conf = this.findTomcatFileOrDirectory("conf");
        if (StringUtils.isNotBlank((String)conf)) {
            this.applicationInfoBundles.add(new WildcardApplicationFileBundle(BundleManifest.TOMCAT_CONFIG, "stp.zip.include.tomcat.conf", "stp.zip.include.tomcat.conf.description", conf, "^.*.(xml|properties|policy)$"));
        }
        this.applicationInfoBundles.add(new LegacyAuthenticationConfigurationFileBundle(BundleManifest.AUTH_CONFIG, "stp.zip.include.auth.cfg", "stp.zip.include.auth.cfg.description", this, this.dirService, webInfClassesDir + "/crowd.properties"));
        this.applicationInfoBundles.add(new DefaultApplicationFileBundle(BundleManifest.CACHE_CONFIG, "stp.zip.include.cache.cfg", "stp.zip.include.cache.cfg.description", webInfClassesDir + "/cache.properties", webInfClassesDir + "/oscache.properties"));
        this.applicationInfoBundles.add(new WildcardApplicationFileBundle(BundleManifest.APPLICATION_LOGS, "stp.zip.include.jira.logs", "stp.zip.include.jira.logs.description", this.getApplicationHome() + "/log", "^.*\\.log.*"));
        String logs = this.findTomcatFileOrDirectory("logs");
        if (StringUtils.isNotBlank((String)logs)) {
            this.applicationInfoBundles.add(new WildcardApplicationFileBundle(BundleManifest.TOMCAT_LOGS, "stp.zip.include.tomcat.logs", "stp.zip.include.tomcat.logs.description", logs, "^.*\\.(log|out)$"));
        }
    }

    @Override
    public List<ScanItem> getApplicationLogFilePaths() {
        String logFilePath = this.applicationProperties.getHomeDirectory() + "/log/atlassian-jira.log";
        if (new File(logFilePath).exists()) {
            return Collections.singletonList(ScanItem.createDefaultItem(logFilePath));
        }
        return Collections.emptyList();
    }

    @Override
    public String getCreateSupportRequestEmail() {
        return "jira-support@atlassian.com";
    }

    @Override
    public String getApplicationSEN() {
        return this.licenseService.getLicense().getSupportEntitlementNumber();
    }

    @Override
    public String getApplicationServerID() {
        return this.licenseService.getServerId();
    }

    @Override
    public PropertyStore loadProperties() {
        PropertyStore store = super.loadProperties();
        PropertyStore systemStore = store.addCategory("stp.properties.system.info");
        systemStore.putValues(this.utils.getProps());
        PropertyStore jvmStatsStore = store.addCategory("stp.properties.memory.statistics");
        jvmStatsStore.putValues(this.cloneNullSafe(this.utils.getJvmStats()));
        PropertyStore appInfoStore = store.addCategory("stp.properties.application.info");
        appInfoStore.putValues(this.cloneNullSafe(this.utils.getBuildStats()));
        List upgradeHistory = this.utils.getUpgradeHistory();
        for (UpgradeHistoryItem upgrade : upgradeHistory) {
            PropertyStore upgradeStore = appInfoStore.addCategory("stp.properties.upgrade");
            upgradeStore.setValue("stp.properties.upgrade.time", this.factory.formatter().format(upgrade.getTimePerformed()));
            upgradeStore.setValue("stp.properties.upgrade.version", upgrade.getTargetVersion());
            upgradeStore.setValue("stp.properties.upgrade.build", upgrade.getTargetBuildNumber());
        }
        PropertyStore languageProperties = store.addCategory("stp.properties.languages.installed");
        for (Locale language : this.localeManager.getInstalledLocales()) {
            PropertyStore languageStore = languageProperties.addCategory("stp.properties.languages.language");
            languageStore.setValue("stp.properties.languages.language.abbreviation", language.getLanguage());
            languageStore.setValue("stp.properties.languages.language.name", language.getDisplayLanguage());
            languageStore.setValue("stp.properties.languages.language.country", language.getDisplayCountry());
            if (!language.equals(this.utils.getDefaultLanguage())) continue;
            languageStore.setValue("stp.properties.languages.default", "true");
        }
        PropertyStore licenseProperties = store.addCategory("stp.properties.license.info");
        licenseProperties.putValues(this.utils.getLicenseInfo());
        PropertyStore configStore = store.addCategory("stp.properties.config.info");
        configStore.putValues(this.utils.getCommonConfigProperties());
        PropertyStore dbStatsStore = store.addCategory("stp.properties.db.statistics");
        dbStatsStore.putValues(this.utils.getUsageStats());
        PropertyStore filePathStore = store.addCategory("stp.properties.path.info");
        filePathStore.setValue(JIRA_HOME, this.utils.getJiraHomeLocation());
        filePathStore.setValue(JIRA_ENTITYENGINE_LOCATION, this.utils.getEntityEngineXmlPath());
        filePathStore.setValue(JIRA_LOG_LOCATION, this.utils.getLogPath());
        filePathStore.setValue(JIRA_INDEX_LOCATION, this.utils.getIndexLocation());
        filePathStore.setValue(JIRA_ATTACHMENT_LOCATION, this.utils.getAttachmentsLocation());
        filePathStore.setValue(JIRA_BACKUP_LOCATION, this.utils.getBackupLocation());
        PropertyStore listenersStore = store.addCategory("stp.properties.listeners");
        for (Object listenerObject : this.utils.getListeners().toArray()) {
            Map listener = (Map)listenerObject;
            if (listener.get("clazz") == null || listener.get("name") == null) continue;
            PropertyStore listenerStore = listenersStore.addCategory("stp.properties.listeners.listener");
            listenerStore.setValue("stp.properties.listeners.listener.name", listener.get("name").toString());
            listenerStore.setValue("stp.properties.listeners.listener.clazz", listener.get("clazz").toString());
        }
        DecimalFormat df = new DecimalFormat("#");
        PropertyStore servicesStore = store.addCategory("stp.properties.services");
        Collection services = this.utils.getServices();
        for (JiraServiceContainer service : services) {
            PropertyStore serviceStore = servicesStore.addCategory("stp.properties.services.service");
            serviceStore.setValue("stp.properties.services.service.name", service.getName());
            serviceStore.setValue("stp.properties.services.service.delay", df.format(service.getDelay() / 1000L) + "ms");
            if (service instanceof UnloadableJiraServiceContainer) {
                serviceStore.setValue("stp.properties.services.service.status", "unloaded");
                continue;
            }
            serviceStore.setValue("stp.properties.services.service.last.run", this.factory.formatter().format(new Date(service.getLastRun())));
            if (service.getDescription() == null) continue;
            serviceStore.setValue("stp.properties.services.service.description", service.getDescription());
        }
        Collection plugins = this.utils.getPlugins();
        PluginMetadataManager pluginMetadataManager = (PluginMetadataManager)ComponentManager.getComponent(PluginMetadataManager.class);
        PropertyStore pluginProperties = store.addCategory("stp.properties.plugins.enabled");
        for (Plugin plugin : plugins) {
            PluginInformation pluginInformation = plugin.getPluginInformation();
            PropertyStore pluginStore = pluginProperties.addCategory("stp.properties.plugins.plugin");
            pluginStore.setValue("stp.properties.plugins.plugin.key", plugin.getKey());
            pluginStore.setValue("stp.properties.plugins.plugin.name", plugin.getName());
            pluginStore.setValue("stp.properties.plugins.plugin.version", pluginInformation.getVersion());
            pluginStore.setValue("stp.properties.plugins.plugin.vendor", pluginInformation.getVendorName());
            pluginStore.setValue("stp.properties.plugins.plugin.status", plugin.getPluginState().toString());
            pluginStore.setValue("stp.properties.plugins.plugin.vendor.url", pluginInformation.getVendorUrl());
            pluginStore.setValue("stp.properties.plugins.plugin.framework.version", String.valueOf(plugin.getPluginsVersion()));
            pluginStore.setValue("stp.properties.plugins.plugin.user.installed", pluginMetadataManager.isUserInstalled(plugin) ? "true" : "false");
            pluginStore.setValue("stp.properties.plugins.plugin.bundled", plugin.isBundledPlugin() ? this.getText("stp.properties.plugins.plugin.bundled") : this.getText("stp.properties.plugins.plugin.user.installed"));
        }
        PropertyStore applicationProperties = store.addCategory("stp.properties.application.properties");
        applicationProperties.putValues(this.utils.getApplicationPropertiesFormatted(", "));
        PropertyStore patchesStore = store.addCategory("stp.properties.patches");
        for (AppliedPatchInfo patch : AppliedPatches.getAppliedPatches()) {
            PropertyStore patchStore = patchesStore.addCategory("stp.properties.patches.patch");
            patchStore.setValue("stp.properties.patches.patch.key", patch.getIssueKey());
            patchStore.setValue("stp.properties.patches.patch.description", patch.getDescription());
        }
        return store;
    }

    private String getStringNotNull(Object o) {
        return o == null ? "" : o.toString();
    }

    private Map<String, String> cloneNullSafe(Map<?, ?> map) {
        HashMap<String, String> retMap = new HashMap<String, String>(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = this.getStringNotNull(entry.getKey());
            String value = this.getStringNotNull(entry.getValue());
            retMap.put(key, value);
        }
        return retMap;
    }

    @Override
    public String getMailQueueURL(HttpServletRequest req) {
        return this.getBaseURL(req) + "/secure/admin/MailQueueAdmin!default.jspa";
    }

    @Override
    public boolean isMailExceptionAvailable() {
        return false;
    }

    @Override
    public String getMailServerConfigurationURL(HttpServletRequest request) {
        return this.getBaseURL(request) + "/secure/admin/ViewMailServers.jspa";
    }

    @Override
    public FileSanitizer getFileSanitizer() {
        return new FileSanitizer(FILE_PATTERNS);
    }

    @Override
    public List<String> getSystemWarnings() {
        return SystemEnvironmentChecklist.getWarningMessages((Locale)Locale.getDefault(), (boolean)false);
    }

    @Override
    public String getApplicationLogDir() {
        return this.getApplicationHome() + "/log";
    }

    @Override
    public ApplicationLicenseInfo getLicenseInfo() {
        return new ApplicationLicenseInfo(){

            @Override
            public boolean isStarter() {
                return JiraApplicationInfo.this.licenseService.getLicense().isStarter();
            }

            @Override
            public boolean isEvaluation() {
                return JiraApplicationInfo.this.licenseService.getLicense().isEvaluation();
            }

            @Override
            public boolean isEntitledToSupport() {
                return JiraApplicationInfo.this.licenseService.getLicense().isEntitledToSupport();
            }

            @Override
            public String getSEN() {
                return JiraApplicationInfo.this.getApplicationSEN();
            }

            @Override
            public Date getMaintenanceExpiryDate() {
                OutlookDate oDate = JiraApplicationInfo.this.outlookDateManager.getOutlookDate(Locale.getDefault());
                String dateStr = JiraApplicationInfo.this.licenseService.getLicense().getMaintenanceEndString(oDate);
                try {
                    return oDate.parseDatePicker(dateStr);
                }
                catch (ParseException e) {
                    return null;
                }
            }
        };
    }

    static {
        FILE_PATTERNS.put("osuser.xml", Arrays.asList(Pattern.compile("(?:.*<property name=\"principal\">)(.*)(?:</property>.*)"), Pattern.compile("(?:.*<property name=\"credentials\">)(.*)(?:</property>.*)")));
        FILE_PATTERNS.put("dbconfig.xml", Arrays.asList(Pattern.compile("<username>([^<]+)</username>"), Pattern.compile("<password>([^<]+)</password>")));
    }
}

