/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext;

import com.atlassian.bamboo.configuration.SystemInfo;
import com.atlassian.bamboo.configuration.SystemStatisticsBean;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.api.bamboo.BambooLicense;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sisyphus.SisyphusPatternSource;
import com.atlassian.spring.container.LazyComponentReference;
import com.atlassian.support.tools.hercules.ScanItem;
import com.atlassian.support.tools.properties.PropertyStore;
import com.atlassian.support.tools.properties.SupportInfoAppenderManager;
import com.atlassian.support.tools.properties.SupportInfoXmlKeyResolver;
import com.atlassian.support.tools.salext.AbstractSupportApplicationInfo;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import com.atlassian.support.tools.salext.bundle.DefaultApplicationFileBundle;
import com.atlassian.support.tools.salext.license.ApplicationLicenseInfo;
import com.atlassian.support.tools.salext.license.ProductLicenseInfo;
import com.atlassian.support.tools.zip.FileSanitizer;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class BambooApplicationInfo
extends AbstractSupportApplicationInfo {
    private static final String LICENSE_BAMBOO_MAX_PLANS = "stp.properties.license.bamboo.max.plans";
    private static final String LICENSE_BAMBOO_MAX_USERS = "stp.properties.license.bamboo.max.users";
    private static final String LICENSE_BAMBOO_MAX_REMOTE = "stp.properties.license.bamboo.max.remote";
    private static final String LICENSE_BAMBOO_MAX_LOCAL = "stp.properties.license.bamboo.max.local";
    private static final String BAMBOO_USAGE_RESULTS = "stp.properties.bamboo.results.count";
    private static final String BAMBOO_USAGE_PLANS = "stp.properties.bamboo.plans.count";
    private static final String BAMBOO_INDEX_TIME = "stp.properties.bamboo.index.time";
    private static final String BAMBOO_BUILD_DATA_DIRECTORY = "stp.properties.bamboo.build.data.directory";
    private static final String BAMBOO_BASE_BUILD_WORK_DIRECTORY = "stp.properties.bamboo.base.build.work.directory";
    private static final String BAMBOO_ARTIFACT_ROOT = "stp.properties.bamboo.artifact.root";
    private static final String BAMBOO_CONFIG_PATH = "stp.properties.bamboo.config.path";
    private static final String BAMBOO_BUILD_WORK_DIRECTORY = "stp.properties.bamboo.build.work.directory";
    private static final String BAMBOO_BUILD_PATH = "stp.properties.bamboo.build.path";
    private static final String BAMBOO_ARTIFACTS_DIRECTORY = "stp.properties.bamboo.artifacts.directory";
    private static final String BAMBOO_APP_SERVER_CONTAINER = "stp.properties.bamboo.app.server.container";
    private static final String BAMBOO_HOME = "stp.properties.bamboo.home";
    private static final String ZIP_INCLUDE_BAMBOO_LOG_DESCRIPTION = "stp.zip.include.bamboo.log.description";
    private static final String ZIP_INCLUDE_BAMBOO_LOG = "stp.zip.include.bamboo.log";
    private static final String ZIP_INCLUDE_BAMBOO_CFG_DESCRIPTION = "stp.zip.include.bamboo.cfg.description";
    private static final String ZIP_INCLUDE_BAMBOO_CFG = "stp.zip.include.bamboo.cfg";
    private static final Map<String, List<Pattern>> FILE_PATTERNLIST = new HashMap<String, List<Pattern>>();
    private final LazyComponentReference<SystemInfo> systemInfoReference = new LazyComponentReference("systemInfo");
    private final LazyComponentReference<SystemStatisticsBean> systemStatisticsBean = new LazyComponentReference("systemStatisticsBean");
    private final LazyComponentReference<BambooLicenseManager> licenseManager = new LazyComponentReference("bambooLicenseManager");
    private final PluginAccessor pluginAccessor;

    public BambooApplicationInfo(ApplicationProperties applicationProperties, I18nResolver i18nResolver, UserManager userManager, TemplateRenderer renderer, SupportInfoAppenderManager supportInfoAppenderManager, SupportInfoXmlKeyResolver supportInfoXmlKeyResolver, PluginAccessor pluginAccessor, BambooAuthenticationContext authenticationContext) {
        super(applicationProperties, i18nResolver, userManager, renderer, supportInfoAppenderManager, supportInfoXmlKeyResolver);
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public void initServletInfo(ServletConfig config) {
        super.initServletInfo(config);
        boolean bambooRunningAsServiceOnLocalSystemAccount = SystemUtils.IS_OS_WINDOWS && "SYSTEM".equals(SystemUtils.USER_NAME);
        String webInfClassesDir = this.getServletContextPath("WEB-INF/classes");
        this.applicationInfoBundles.add(new DefaultApplicationFileBundle(BundleManifest.APPLICATION_CONFIG, ZIP_INCLUDE_BAMBOO_CFG, ZIP_INCLUDE_BAMBOO_CFG_DESCRIPTION, new File(SystemDirectory.getApplicationHome(), "bamboo.cfg.xml").getAbsolutePath(), new File(SystemDirectory.getApplicationHome(), "bamboo-mail.cfg.xml").getAbsolutePath(), new File(SystemDirectory.getConfigDirectory(), "administration.xml").getAbsolutePath()));
        this.applicationInfoBundles.add(new DefaultApplicationFileBundle(BundleManifest.AUTH_CONFIG, "stp.zip.include.auth.cfg", "stp.zip.include.auth.cfg.description", new File(SystemDirectory.getConfigDirectory(), "atlassian-user.xml").getAbsolutePath(), new File(SystemDirectory.getConfigDirectory(), "atlassian-user-custom.xml").getAbsolutePath(), new File(SystemDirectory.getConfigDirectory(), "crowd.properties").getAbsolutePath(), webInfClassesDir + "/seraph-config.xml"));
        ArrayList<String> logFileList = new ArrayList<String>();
        logFileList.add(SystemDirectory.getLogFile().getAbsolutePath());
        if (bambooRunningAsServiceOnLocalSystemAccount) {
            logFileList.add(StringUtils.join(Arrays.asList(System.getenv("WINDIR"), "System32", "Config", "systemprofile", "bamboo.log"), (String)File.separator));
        } else {
            logFileList.add(new File(SystemUtils.getUserHome(), "bamboo.log").getAbsolutePath());
        }
        String[] logFileArray = logFileList.toArray(new String[logFileList.size()]);
        this.applicationInfoBundles.add(new DefaultApplicationFileBundle(BundleManifest.APPLICATION_LOGS, ZIP_INCLUDE_BAMBOO_LOG, ZIP_INCLUDE_BAMBOO_LOG_DESCRIPTION, logFileArray));
    }

    @Override
    public List<ScanItem> getApplicationLogFilePaths() {
        File logFile = SystemDirectory.getLogFile();
        if (logFile.exists()) {
            return Collections.singletonList(ScanItem.createDefaultItem(logFile.getAbsoluteFile().toString()));
        }
        return Collections.emptyList();
    }

    @Override
    public SisyphusPatternSource getPatternSource() throws IOException, ClassNotFoundException, MalformedURLException {
        return super.getPatternSourceByURL("https://confluence.atlassian.com/download/attachments/179443532/bamboo_regex.xml", this.getProxy());
    }

    @Override
    public String getCreateSupportRequestEmail() {
        return "bamboo-support-system@atlassian.com";
    }

    @Override
    public String getMailQueueURL(HttpServletRequest request) {
        return null;
    }

    @Override
    public boolean isMailExceptionAvailable() {
        return true;
    }

    @Override
    public String getMailServerConfigurationURL(HttpServletRequest request) {
        return this.getBaseURL(request) + "/admin/viewMailServer.action";
    }

    @Override
    public FileSanitizer getFileSanitizer() {
        return new FileSanitizer(FILE_PATTERNLIST);
    }

    @Override
    public String getApplicationSEN() {
        BambooLicense license = ((BambooLicenseManager)this.licenseManager.get()).getLicense();
        return license.getSupportEntitlementNumber();
    }

    @Override
    public String getApplicationServerID() {
        BambooLicense license = ((BambooLicenseManager)this.licenseManager.get()).getLicense();
        return license.getServerId();
    }

    @Override
    public PropertyStore loadProperties() {
        PropertyStore store = super.loadProperties();
        PropertyStore sysInfo = store.addCategory("stp.properties.system.info");
        SystemInfo systemInfo = (SystemInfo)this.systemInfoReference.get();
        sysInfo.setValue(BAMBOO_HOME, systemInfo.getApplicationHome());
        sysInfo.setValue(BAMBOO_APP_SERVER_CONTAINER, this.servletContext.getServerInfo());
        sysInfo.setValue(BAMBOO_ARTIFACTS_DIRECTORY, systemInfo.getArtifactsDirectory());
        sysInfo.setValue(BAMBOO_BUILD_PATH, systemInfo.getBuildPath());
        sysInfo.setValue(BAMBOO_BUILD_WORK_DIRECTORY, systemInfo.getBuildWorkingDirectory());
        sysInfo.setValue(BAMBOO_CONFIG_PATH, systemInfo.getConfigPath());
        sysInfo.setValue("stp.properties.current.directory", systemInfo.getCurrentDirectory());
        sysInfo.setValue("stp.properties.free.disk.space", systemInfo.getFreeDiskSpace());
        sysInfo.setValue("stp.properties.host.name", systemInfo.getHostName());
        sysInfo.setValue("stp.properties.index.size", systemInfo.getIndexSize());
        sysInfo.setValue("stp.properties.ip.address", systemInfo.getIpAddress());
        sysInfo.setValue("stp.properties.os", systemInfo.getOperatingSystem());
        sysInfo.setValue("stp.properties.os.architecture", systemInfo.getOperatingSystemArchitecture());
        sysInfo.setValue("stp.properties.system.date", systemInfo.getSystemDate());
        sysInfo.setValue("stp.properties.system.encoding", systemInfo.getSystemEncoding());
        sysInfo.setValue("stp.properties.system.time", systemInfo.getSystemTime());
        sysInfo.setValue("stp.properties.system.temp.directory", systemInfo.getTempDir());
        sysInfo.setValue("stp.properties.application.uptime", systemInfo.getUptime());
        sysInfo.setValue("stp.properties.user.home", systemInfo.getUserHome());
        sysInfo.setValue("stp.properties.user.locale", systemInfo.getUserLocale());
        sysInfo.setValue("stp.properties.user.name", systemInfo.getUserName());
        sysInfo.setValue("stp.properties.user.timezone", systemInfo.getUserTimezone());
        sysInfo.setValue("stp.properties.system.available.processors", String.valueOf(systemInfo.getAvailableProcessors()));
        sysInfo.setValue("stp.properties.memory.total", String.valueOf(systemInfo.getTotalMemory()));
        sysInfo.setValue("stp.properties.memory.used", String.valueOf(systemInfo.getUsedMemory()));
        PropertyStore sysProps = store.addCategory("stp.properties.system.info");
        Properties properties = System.getProperties();
        for (Object key : properties.keySet()) {
            sysProps.setValue((String)key, properties.getProperty((String)key));
        }
        PropertyStore pathInfo = store.addCategory("stp.properties.path.info");
        pathInfo.setValue(BAMBOO_HOME, SystemDirectory.getApplicationHome().getAbsolutePath());
        pathInfo.setValue(BAMBOO_ARTIFACT_ROOT, SystemDirectory.getArtifactRootStorageDirectory().getAbsolutePath());
        pathInfo.setValue(BAMBOO_BASE_BUILD_WORK_DIRECTORY, SystemDirectory.getBaseBuildWorkingDirectory().getAbsolutePath());
        pathInfo.setValue(BAMBOO_BUILD_DATA_DIRECTORY, SystemDirectory.getBuildDataDirectory().getAbsolutePath());
        pathInfo.setValue("stp.properties.cache.directory", SystemDirectory.getCacheDirectory().getAbsolutePath());
        pathInfo.setValue("stp.properties.config.directory", SystemDirectory.getConfigDirectory().getAbsolutePath());
        pathInfo.setValue("stp.properties.log.directory", SystemDirectory.getLogFile().getAbsolutePath());
        pathInfo.setValue("stp.properties.plugin.cache.directory", SystemDirectory.getPluginCacheDirectory().getAbsolutePath());
        pathInfo.setValue("stp.properties.plugin.directory", SystemDirectory.getPluginDirectory().getAbsolutePath());
        PropertyStore statsInfo = store.addCategory("stp.properties.statistics");
        SystemStatisticsBean statisticsBean = (SystemStatisticsBean)this.systemStatisticsBean.get();
        statsInfo.setValue(BAMBOO_INDEX_TIME, String.valueOf(statisticsBean.getApproximateIndexTime()));
        statsInfo.setValue(BAMBOO_USAGE_PLANS, String.valueOf(statisticsBean.getNumberOfPlans()));
        statsInfo.setValue(BAMBOO_USAGE_RESULTS, String.valueOf(statisticsBean.getNumberOfResults()));
        PropertyStore pluginsStore = store.addCategory("stp.properties.plugins");
        for (Plugin plugin : this.pluginAccessor.getPlugins()) {
            PropertyStore pluginStore = pluginsStore.addCategory("stp.properties.plugins.plugin");
            PluginInformation info = plugin.getPluginInformation();
            pluginStore.setValue("stp.properties.plugins.plugin.key", plugin.getKey());
            pluginStore.setValue("stp.properties.plugins.plugin.name", plugin.getName());
            pluginStore.setValue("stp.properties.plugins.plugin.version", info.getVersion());
            pluginStore.setValue("stp.properties.plugins.plugin.vendor", info.getVendorName());
            pluginStore.setValue("stp.properties.plugins.plugin.status", plugin.getPluginState().toString());
            pluginStore.setValue("stp.properties.plugins.plugin.bundled", plugin.isBundledPlugin() ? this.getText("stp.properties.plugins.plugin.bundled") : this.getText("stp.properties.plugins.plugin.user.installed"));
        }
        BambooLicense license = ((BambooLicenseManager)this.licenseManager.get()).getLicense();
        PropertyStore licenseInfo = store.addCategory("stp.properties.license");
        licenseInfo.setValue("stp.properties.license.purchased", license.getPurchaseDate().toString());
        licenseInfo.setValue("stp.properties.license.description", license.getDescription());
        licenseInfo.setValue("stp.properties.license.sen", license.getSupportEntitlementNumber());
        licenseInfo.setValue("stp.properties.license.server.id", license.getServerId());
        licenseInfo.setValue("stp.properties.license.edition", license.getLicenseEdition().name());
        licenseInfo.setValue("stp.properties.license.type", license.getLicenseType().name());
        licenseInfo.setValue("stp.properties.license.expires", license.getExpiryDate() != null ? license.getExpiryDate().toString() : "stp.properties.license.expires.none");
        licenseInfo.setValue(LICENSE_BAMBOO_MAX_LOCAL, String.valueOf(license.getMaximumNumberOfLocalAgents()));
        licenseInfo.setValue(LICENSE_BAMBOO_MAX_REMOTE, String.valueOf(license.getMaximumNumberOfRemoteAgents()));
        licenseInfo.setValue(LICENSE_BAMBOO_MAX_USERS, String.valueOf(license.getMaximumNumberOfUsers()));
        licenseInfo.setValue(LICENSE_BAMBOO_MAX_PLANS, String.valueOf(license.getMaximumNumberOfPlans()));
        return store;
    }

    @Override
    public String getApplicationLogDir() {
        return SystemDirectory.getLogFile().getAbsoluteFile().toString();
    }

    @Override
    public ApplicationLicenseInfo getLicenseInfo() {
        BambooLicense license = ((BambooLicenseManager)this.licenseManager.get()).getLicense();
        return new ProductLicenseInfo((ProductLicense)license);
    }

    static {
        FILE_PATTERNLIST.putAll(FILE_PATTERNS);
        FILE_PATTERNLIST.put("bamboo.cfg.xml", Arrays.asList(Pattern.compile("(?:.*<property name=\"hibernate\\.connection\\.username\">)(.*)(?:</property>.*)"), Pattern.compile("(?:.*<property name=\"hibernate\\.connection\\.password\">)(.*)(?:</property>.*)"), Pattern.compile("(?:.*<property name=\"license\\.string\">)(.*)(?:</property>.*)")));
        FILE_PATTERNLIST.put("bamboo-mail.cfg.xml", Arrays.asList(Pattern.compile("(?:.*<password>)(.*)(?:</password>.*)"), Pattern.compile("(?:.*<username>)(.*)(?:</username>.*)")));
    }
}

