/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.hercules;

import com.atlassian.support.tools.hercules.FileProgressMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;

public class FileProgressMonitorInputStream
extends FilterInputStream {
    private final long size;
    private long nread = 0L;
    private final FileProgressMonitor monitor;

    public FileProgressMonitorInputStream(File file, FileProgressMonitor monitor) throws FileNotFoundException {
        super(new FileInputStream(file));
        this.monitor = monitor;
        this.size = file.length();
        monitor.setTotalSize(this.size);
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            this.monitor.setProgress(++this.nread);
        }
        if (this.monitor.isCancelled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            exc.bytesTransferred = (int)this.nread;
            throw exc;
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        if (nr > 0) {
            this.monitor.setProgress(this.nread += (long)nr);
        }
        if (this.monitor.isCancelled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            exc.bytesTransferred = (int)this.nread;
            throw exc;
        }
        return nr;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        if (nr > 0) {
            this.monitor.setProgress(this.nread += (long)nr);
        }
        if (this.monitor.isCancelled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            exc.bytesTransferred = (int)this.nread;
            throw exc;
        }
        return nr;
    }

    @Override
    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this.monitor.setProgress(this.nread += nr);
        }
        return nr;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nread = this.size - (long)this.in.available();
        this.monitor.setProgress(this.nread);
    }
}

