/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sisyphus;

import com.atlassian.sisyphus.DefaultMatchResultVisitor;
import com.atlassian.sisyphus.LogLine;
import com.atlassian.sisyphus.MatchResultVisitor;
import com.atlassian.sisyphus.PatternMatchSet;
import com.atlassian.sisyphus.SisyphusDateMatcher;
import com.atlassian.sisyphus.SisyphusPattern;
import com.atlassian.sisyphus.SisyphusPatternMatcher;
import com.atlassian.sisyphus.SisyphusPatternSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSisyphusPatternMatcher
implements SisyphusPatternMatcher {
    private static final Logger log = Logger.getLogger(DefaultSisyphusPatternMatcher.class);
    private static final int MAX_LINE_LENGTH = 5000;
    private final SisyphusPatternSource patternSource;

    public DefaultSisyphusPatternMatcher(SisyphusPatternSource patternSource) {
        this.patternSource = patternSource;
    }

    @Override
    public Map<String, PatternMatchSet> match(BufferedReader reader) throws IOException, InterruptedException {
        DefaultMatchResultVisitor visitor = new DefaultMatchResultVisitor();
        this.match(reader, visitor);
        return visitor.getResults();
    }

    @Override
    public void match(BufferedReader reader, MatchResultVisitor visitor) throws IOException, InterruptedException {
        String thisLine;
        Date latestDate = null;
        int lineCount = 1;
        int truncatedLineCount = 0;
        int maxLength = 0;
        while ((thisLine = reader.readLine()) != null) {
            Date currentDate;
            if (thisLine.length() > 5000) {
                if (maxLength < thisLine.length()) {
                    maxLength = thisLine.length();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Truncating a long line of length: " + thisLine.length() + " to " + 5000 + ". Data:\n" + thisLine + "\n"));
                }
                ++truncatedLineCount;
                thisLine = thisLine.substring(0, 5000);
            }
            if ((currentDate = SisyphusDateMatcher.extractDate(thisLine)) != null) {
                latestDate = currentDate;
            }
            this.matchLine(thisLine, new LogLine(lineCount, latestDate), visitor);
            ++lineCount;
        }
        if (truncatedLineCount > 0) {
            log.error((Object)("Truncated " + truncatedLineCount + " lines to " + 5000 + ". Max length: " + maxLength));
        }
    }

    protected void matchLine(String thisLine, LogLine datedLine, MatchResultVisitor visitor) throws InterruptedException {
        long lineTime = System.currentTimeMillis();
        Iterator iterator = this.patternSource.iterator();
        while (iterator.hasNext()) {
            if (Thread.currentThread().isInterrupted() || visitor.isCancelled()) {
                throw new InterruptedException();
            }
            SisyphusPattern sPattern = (SisyphusPattern)iterator.next();
            if (sPattern.isBrokenPattern()) continue;
            Pattern pat = sPattern.getPattern();
            if (pat != null) {
                long matchDuration;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Current Pattern being evaluated: " + sPattern.toString()));
                }
                long matchtime = System.currentTimeMillis();
                Matcher matcher = sPattern.getMatcher();
                matcher.reset(thisLine);
                if (matcher.find()) {
                    visitor.patternMatched(thisLine, datedLine, sPattern);
                }
                if (!log.isDebugEnabled() || (matchDuration = System.currentTimeMillis() - matchtime) < 5L) continue;
                log.debug((Object)("Slow match. Time from find() method: " + matchDuration + " milliseconds. Regex being used is: '" + sPattern.getRegex() + "' and 'thisLine' is " + thisLine.length() + " characters long."));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Regexp would not compile and was skipped: " + sPattern.getRegex()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Time from line scan (all regexs): " + (System.currentTimeMillis() - lineTime) + " milliseconds."));
        }
    }
}

