package com.atlassian.support.tools.salext.license;

import java.util.Date;

import com.atlassian.extras.api.LicenseType;
import com.atlassian.extras.api.ProductLicense;

public class ProductLicenseInfo implements ApplicationLicenseInfo
{
	private final ProductLicense license;
	
	public ProductLicenseInfo(ProductLicense license)
	{
		this.license = license;
	}

	@Override
	public Date getMaintenanceExpiryDate()
	{
		return license.getMaintenanceExpiryDate();
	}

	@Override
	public boolean isEntitledToSupport()
	{
		LicenseType licenseType = license.getLicenseType();
		if(licenseType == LicenseType.DEMONSTRATION)
			return false;
		if(licenseType == LicenseType.TESTING)
			return false;
		if(licenseType == LicenseType.NON_PROFIT)
			return false;
		if(licenseType == LicenseType.PERSONAL)
			return false;
		return true;
	}

	@Override
	public boolean isEvaluation()
	{
		return license.isEvaluation();
	}

	@Override
	public boolean isStarter()
	{
		return license.getLicenseType() == LicenseType.STARTER;
	}

	@Override
	public String getSEN()
	{
		return license.getSupportEntitlementNumber();
	}
}
