package com.atlassian.support.tools.salext.license;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.sal.api.user.UserManager;
import org.apache.commons.lang.StringUtils;

import java.util.Map;

/**
 * This checks whether it makes sense to show the license reminder to the user. Currently any logged user will do. This
 * prevents 401 (Unauthorized) when using the javascript to check the REST itf for license validity, and it is cross-product stable
 */
public class HasLicensePermissionCondition implements Condition
{
    private final UserManager userManager;

    public HasLicensePermissionCondition(final UserManager userManager)
    {
        this.userManager = userManager;
    }

    @Override
    public void init(Map<String, String> stringStringMap) throws PluginParseException
    {
    }

    @Override
    public boolean shouldDisplay(Map<String, Object> stringObjectMap)
    {

        String remoteUsername = userManager.getRemoteUsername();
        if(StringUtils.isBlank(remoteUsername))
        {
            return false;
        }
        return userManager.isAdmin(remoteUsername);
    }
}